/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.function.RunnableWithException;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorServiceHelpers {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceHelpers.class);

    public static ThreadFactory getThreadFactory(String groupName) {
        return ExecutorServiceHelpers.getThreadFactory(groupName, 5);
    }

    public static ThreadFactory getThreadFactory(final String groupName, final int priority) {
        return new ThreadFactory(){
            final AtomicInteger threadCount = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, groupName + "-" + this.threadCount.incrementAndGet());
                thread.setUncaughtExceptionHandler(new LogUncaughtExceptions());
                thread.setDaemon(true);
                thread.setPriority(priority);
                return thread;
            }
        };
    }

    public static ScheduledExecutorService newScheduledThreadPool(int size, String poolName) {
        return ExecutorServiceHelpers.newScheduledThreadPool(size, poolName, 5);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int size, String poolName, int threadPriority) {
        ThreadFactory threadFactory = ExecutorServiceHelpers.getThreadFactory(poolName, threadPriority);
        ScheduledThreadPoolExecutor result = new ScheduledThreadPoolExecutor(size, threadFactory, new CallerRuns(poolName));
        result.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        result.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        result.setRemoveOnCancelPolicy(true);
        return result;
    }

    public static Snapshot getSnapshot(ExecutorService service) {
        Preconditions.checkNotNull(service, "service");
        if (service instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)service;
            return new Snapshot(tpe.getQueue().size(), tpe.getActiveCount(), tpe.getPoolSize());
        }
        if (service instanceof ForkJoinPool) {
            ForkJoinPool fjp = (ForkJoinPool)service;
            return new Snapshot(fjp.getQueuedSubmissionCount(), fjp.getActiveThreadCount(), fjp.getPoolSize());
        }
        return null;
    }

    public static ThreadPoolExecutor getShrinkingExecutor(int maxThreadCount, int threadTimeout, String poolName) {
        return new ThreadPoolExecutor(0, maxThreadCount, threadTimeout, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ExecutorServiceHelpers.getThreadFactory(poolName), new CallerRuns(poolName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(RunnableWithException task, Consumer<Throwable> exceptionHandler, Runnable runFinally, Executor executor) {
        Preconditions.checkNotNull(task, "task");
        Preconditions.checkNotNull(exceptionHandler, "exceptionHandler");
        Preconditions.checkNotNull(runFinally, "runFinally");
        boolean scheduledSuccess = false;
        try {
            executor.execute(() -> {
                try {
                    task.run();
                }
                catch (Throwable ex) {
                    if (!Exceptions.mustRethrow(ex)) {
                        exceptionHandler.accept(ex);
                    }
                }
                finally {
                    runFinally.run();
                }
            });
            scheduledSuccess = true;
        }
        finally {
            if (!scheduledSuccess) {
                runFinally.run();
            }
        }
    }

    public static void shutdown(ExecutorService ... pools) {
        ExecutorServiceHelpers.shutdown(Duration.ofSeconds(5L), pools);
    }

    public static void shutdown(Duration timeout, ExecutorService ... pools) {
        for (ExecutorService pool : pools) {
            pool.shutdown();
        }
        TimeoutTimer timer = new TimeoutTimer(timeout);
        for (ExecutorService pool : pools) {
            try {
                if (pool.awaitTermination(timer.getRemaining().toMillis(), TimeUnit.MILLISECONDS)) continue;
                pool.shutdownNow();
                if (pool.awaitTermination(timer.getRemaining().toMillis(), TimeUnit.MILLISECONDS)) continue;
                List<Runnable> remainingTasks = pool.shutdownNow();
                log.warn("One or more threads from pool " + pool + " did not shutdown properly. Waiting tasks: " + remainingTasks);
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class Snapshot {
        final int queueSize;
        final int activeThreadCount;
        final int poolSize;

        @ConstructorProperties(value={"queueSize", "activeThreadCount", "poolSize"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Snapshot(int queueSize, int activeThreadCount, int poolSize) {
            this.queueSize = queueSize;
            this.activeThreadCount = activeThreadCount;
            this.poolSize = poolSize;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getQueueSize() {
            return this.queueSize;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getActiveThreadCount() {
            return this.activeThreadCount;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getPoolSize() {
            return this.poolSize;
        }
    }

    private static final class LogUncaughtExceptions
    implements Thread.UncaughtExceptionHandler {
        private LogUncaughtExceptions() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Exception thrown out of root of thread: " + t.getName(), e);
        }
    }

    private static class CallerRuns
    implements RejectedExecutionHandler {
        private final String poolName;

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            log.debug("Caller to executor: " + this.poolName + " rejected and run in the caller.");
            r.run();
        }

        @ConstructorProperties(value={"poolName"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CallerRuns(String poolName) {
            this.poolName = poolName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getPoolName() {
            return this.poolName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallerRuns)) {
                return false;
            }
            CallerRuns other = (CallerRuns)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$poolName = this.getPoolName();
            String other$poolName = other.getPoolName();
            return !(this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CallerRuns;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $poolName = this.getPoolName();
            result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ExecutorServiceHelpers.CallerRuns(poolName=" + this.getPoolName() + ")";
        }
    }
}

