/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.function.Callbacks;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Futures {
    public static <T> CompletableFuture<T> completeOn(CompletableFuture<T> future, Executor executor) {
        CompletableFuture result = new CompletableFuture();
        future.whenCompleteAsync((r, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(r);
            }
        }, executor);
        return result;
    }

    public static <T> boolean await(CompletableFuture<T> f) {
        return Futures.await(f, Long.MAX_VALUE);
    }

    public static <T> boolean await(CompletableFuture<T> f, long timeout) {
        Exceptions.handleInterrupted(() -> {
            try {
                f.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException exception) {
                // empty catch block
            }
        });
        return Futures.isSuccessful(f);
    }

    public static <T> void completeAfter(Supplier<CompletableFuture<? extends T>> futureSupplier, CompletableFuture<T> toComplete) {
        Preconditions.checkArgument(!toComplete.isDone(), "toComplete is already completed.");
        try {
            CompletableFuture<T> f = futureSupplier.get();
            f.thenAccept(toComplete::complete);
            Futures.exceptionListener(f, toComplete::completeExceptionally);
        }
        catch (Throwable ex) {
            toComplete.completeExceptionally(ex);
            throw ex;
        }
    }

    public static <T> boolean isSuccessful(CompletableFuture<T> f) {
        return f.isDone() && !f.isCompletedExceptionally() && !f.isCancelled();
    }

    public static <T> Throwable getException(CompletableFuture<T> future) {
        try {
            future.getNow(null);
            return null;
        }
        catch (Exception e) {
            return Exceptions.unwrap(e);
        }
    }

    public static <ResultT, E1 extends Exception, E2 extends Exception, E3 extends Exception> ResultT getThrowingException(Future<ResultT> future) throws E1, E2, E3 {
        Preconditions.checkNotNull(future);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Exceptions.sneakyThrow(e);
        }
        catch (Exception e) {
            throw Exceptions.sneakyThrow(Exceptions.unwrap(e));
        }
    }

    public static <ResultT, ExceptionT extends Exception> ResultT getAndHandleExceptions(Future<ResultT> future, Function<Throwable, ExceptionT> exceptionConstructor) throws ExceptionT {
        Preconditions.checkNotNull(exceptionConstructor);
        try {
            return (ResultT)Exceptions.handleInterruptedCall(() -> future.get());
        }
        catch (ExecutionException e) {
            Exception result = (Exception)exceptionConstructor.apply(e.getCause());
            if (result == null) {
                return null;
            }
            throw result;
        }
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable exception) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(exception);
        return result;
    }

    public static <T> CompletableFuture<T> cancellableFuture(CompletableFuture<T> source, Consumer<T> onCancel) {
        if (source == null) {
            return null;
        }
        CompletableFuture result = new CompletableFuture();
        source.whenComplete((r, ex) -> {
            if (ex == null) {
                result.complete(r);
            } else {
                result.completeExceptionally((Throwable)ex);
            }
        });
        Futures.exceptionListener(result, ex -> {
            if (ex instanceof CancellationException && !source.isCancelled()) {
                source.thenAccept(onCancel);
            }
        });
        return result;
    }

    public static <T> void exceptionListener(CompletableFuture<T> completableFuture, Consumer<Throwable> exceptionListener) {
        completableFuture.whenComplete((r, ex) -> {
            if (ex != null) {
                Callbacks.invokeSafely(exceptionListener, ex, null);
            }
        });
    }

    public static <T, E extends Throwable> void exceptionListener(CompletableFuture<T> completableFuture, Class<E> exceptionClass, Consumer<E> exceptionListener) {
        completableFuture.whenComplete((r, ex) -> {
            if (ex != null && exceptionClass.isAssignableFrom(ex.getClass())) {
                Callbacks.invokeSafely(exceptionListener, ex, null);
            }
        });
    }

    public static <T> CompletableFuture<T> exceptionallyCompose(CompletableFuture<T> future, Function<Throwable, CompletableFuture<T>> handler) {
        return ((CompletableFuture)future.handle((r, ex) -> {
            if (ex == null) {
                return CompletableFuture.completedFuture(r);
            }
            return (CompletableFuture)handler.apply((Throwable)ex);
        })).thenCompose(f -> f);
    }

    public static <T> CompletableFuture<T> exceptionallyExpecting(CompletableFuture<T> future, Predicate<Throwable> isExpected, T exceptionValue) {
        return future.exceptionally(ex -> {
            if (isExpected.test(Exceptions.unwrap(ex))) {
                return exceptionValue;
            }
            throw new CompletionException((Throwable)ex);
        });
    }

    public static <T> CompletableFuture<T> exceptionallyComposeExpecting(CompletableFuture<T> future, Predicate<Throwable> isExpected, Supplier<CompletableFuture<T>> exceptionFutureSupplier) {
        return Futures.exceptionallyCompose(future, ex -> {
            if (isExpected.test(Exceptions.unwrap(ex))) {
                return (CompletableFuture)exceptionFutureSupplier.get();
            }
            return Futures.failedFuture(ex);
        });
    }

    public static <T> CompletableFuture<Void> toVoid(CompletableFuture<T> future) {
        return future.thenAccept(Callbacks::doNothing);
    }

    public static <T, E extends Exception> CompletableFuture<Void> toVoidExpecting(CompletableFuture<T> future, T expectedValue, Supplier<E> exceptionConstructor) {
        return future.thenApply(value -> Futures.expect(value, expectedValue, exceptionConstructor));
    }

    public static <T, U> CompletableFuture<U> handleCompose(CompletableFuture<T> future, BiFunction<T, Throwable, CompletableFuture<U>> handler) {
        return ((CompletableFuture)future.handle(handler)).thenCompose(f -> f);
    }

    private static <T, E extends Exception> Void expect(T value, T expected, Supplier<E> exceptionConstructor) {
        if (!expected.equals(value)) {
            throw (Exception)exceptionConstructor.get();
        }
        return null;
    }

    public static <T> CompletableFuture<List<T>> allOfWithResults(List<CompletableFuture<T>> futures) {
        CompletableFuture<Void> allDoneFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        return allDoneFuture.thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <K, V> CompletableFuture<Map<K, V>> allOfWithResults(Map<K, CompletableFuture<V>> futureMap) {
        return Futures.allOf(futureMap.values()).thenApply(ignored -> futureMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, future -> ((CompletableFuture)future.getValue()).join())));
    }

    public static <K, V> CompletableFuture<Map<K, V>> keysAllOfWithResults(Map<CompletableFuture<K>, V> futureMap) {
        return Futures.allOf(futureMap.keySet()).thenApply(ignored -> futureMap.entrySet().stream().collect(Collectors.toMap(future -> ((CompletableFuture)future.getKey()).join(), Map.Entry::getValue)));
    }

    public static <T> CompletableFuture<Void> allOf(Collection<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    public static <T> CompletableFuture<List<T>> filter(List<T> input, Function<T, CompletableFuture<Boolean>> predicate) {
        Preconditions.checkNotNull(input);
        Map<Object, CompletableFuture> allFutures = input.stream().collect(Collectors.toMap(key -> key, predicate::apply));
        return Futures.allOf(allFutures.values()).thenApply(ignored -> allFutures.entrySet().stream().filter(e -> (Boolean)((CompletableFuture)e.getValue()).join()).map(Map.Entry::getKey).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<T> futureWithTimeout(Duration timeout, ScheduledExecutorService executorService) {
        return Futures.futureWithTimeout(timeout, null, executorService);
    }

    public static <T> CompletableFuture<T> futureWithTimeout(Duration timeout, String tag, ScheduledExecutorService executorService) {
        return Futures.futureWithTimeout(CompletableFuture::new, timeout, tag, executorService);
    }

    public static <T> CompletableFuture<T> futureWithTimeout(Supplier<CompletableFuture<T>> futureSupplier, Duration timeout, String tag, ScheduledExecutorService executorService) {
        CompletableFuture future = futureSupplier.get();
        ScheduledFuture<Boolean> sf = executorService.schedule(() -> future.completeExceptionally(new TimeoutException(tag)), timeout.toMillis(), TimeUnit.MILLISECONDS);
        return future.whenComplete((r, ex) -> sf.cancel(true));
    }

    public static <T> void onTimeout(CompletableFuture<T> future, Consumer<TimeoutException> callback) {
        Futures.exceptionListener(future, TimeoutException.class, callback);
    }

    public static CompletableFuture<Void> delayedFuture(Duration delay, ScheduledExecutorService executorService) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (delay.toMillis() == 0L) {
            result.complete(null);
        } else {
            ScheduledFuture<Boolean> sf = executorService.schedule(() -> result.complete(null), delay.toMillis(), TimeUnit.MILLISECONDS);
            result.whenComplete((r, ex) -> sf.cancel(true));
        }
        return result;
    }

    public static <T> CompletableFuture<T> delayedFuture(Supplier<CompletableFuture<T>> task, long delay, ScheduledExecutorService executorService) {
        return Futures.delayedFuture(Duration.ofMillis(delay), executorService).thenCompose(v -> (CompletableFuture)task.get());
    }

    public static <T> CompletableFuture<T> delayedTask(Supplier<T> task, Duration delay, ScheduledExecutorService executorService) {
        CompletableFuture result = new CompletableFuture();
        executorService.schedule(() -> result.complete(Futures.runOrFail(() -> Futures.lambda$null$26((Supplier)task), result)), delay.toMillis(), TimeUnit.MILLISECONDS);
        return result;
    }

    public static <T, R> R runOrFail(Callable<R> callable, CompletableFuture<T> future) {
        try {
            return callable.call();
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
            throw t;
        }
    }

    public static <T> CompletableFuture<Void> loop(Iterable<T> iterable, Function<T, CompletableFuture<Boolean>> loopBody, Executor executor) {
        Iterator iterator = iterable.iterator();
        AtomicBoolean canContinue = new AtomicBoolean(true);
        return Futures.loop(() -> iterator.hasNext() && canContinue.get(), () -> (CompletableFuture)loopBody.apply(iterator.next()), canContinue::set, executor);
    }

    public static CompletableFuture<Void> loop(Supplier<Boolean> condition, Supplier<CompletableFuture<Void>> loopBody, Executor executor) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Loop loop = new Loop(condition, loopBody, null, result, executor);
        executor.execute(loop);
        return result;
    }

    public static <T> CompletableFuture<Void> loop(Supplier<Boolean> condition, Supplier<CompletableFuture<T>> loopBody, Consumer<T> resultConsumer, Executor executor) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Loop<T> loop = new Loop<T>(condition, loopBody, resultConsumer, result, executor);
        executor.execute(loop);
        return result;
    }

    public static <T> CompletableFuture<Void> doWhileLoop(Supplier<CompletableFuture<T>> loopBody, Predicate<T> condition, Executor executor) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        AtomicBoolean canContinue = new AtomicBoolean();
        Consumer<Object> iterationResultHandler = ir -> canContinue.set(condition.test(ir));
        ((CompletableFuture)((CompletableFuture)loopBody.get().thenAccept((Consumer)iterationResultHandler)).thenRunAsync(() -> {
            Loop loop = new Loop(canContinue::get, loopBody, iterationResultHandler, result, executor);
            executor.execute(loop);
        }, executor)).exceptionally(ex -> {
            result.completeExceptionally((Throwable)ex);
            return null;
        });
        return result;
    }

    private static /* synthetic */ Object lambda$null$26(Supplier task) throws Exception {
        return task.get();
    }

    private static class Loop<T>
    implements Runnable,
    Callable<Void> {
        final Supplier<Boolean> condition;
        final Supplier<CompletableFuture<T>> loopBody;
        final Consumer<T> resultConsumer;
        final CompletableFuture<Void> result;
        final Executor executor;

        @Override
        public Void call() throws Exception {
            if (this.condition.get().booleanValue()) {
                ((CompletableFuture)((CompletableFuture)this.loopBody.get().thenAccept(this::acceptIterationResult)).exceptionally(this::handleException)).thenRunAsync(this, this.executor);
            } else {
                this.result.complete(null);
            }
            return null;
        }

        @Override
        public void run() {
            Futures.runOrFail(this, this.result);
        }

        private Void handleException(Throwable ex) {
            this.result.completeExceptionally(ex);
            throw new CompletionException(ex);
        }

        private void acceptIterationResult(T iterationResult) {
            if (this.resultConsumer != null) {
                this.resultConsumer.accept(iterationResult);
            }
        }

        @ConstructorProperties(value={"condition", "loopBody", "resultConsumer", "result", "executor"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Loop(Supplier<Boolean> condition, Supplier<CompletableFuture<T>> loopBody, Consumer<T> resultConsumer, CompletableFuture<Void> result, Executor executor) {
            this.condition = condition;
            this.loopBody = loopBody;
            this.resultConsumer = resultConsumer;
            this.result = result;
            this.executor = executor;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Supplier<Boolean> getCondition() {
            return this.condition;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Supplier<CompletableFuture<T>> getLoopBody() {
            return this.loopBody;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Consumer<T> getResultConsumer() {
            return this.resultConsumer;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CompletableFuture<Void> getResult() {
            return this.result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Executor getExecutor() {
            return this.executor;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Loop)) {
                return false;
            }
            Loop other = (Loop)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Supplier<Boolean> this$condition = this.getCondition();
            Supplier<Boolean> other$condition = other.getCondition();
            if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
                return false;
            }
            Supplier<CompletableFuture<T>> this$loopBody = this.getLoopBody();
            Supplier<CompletableFuture<T>> other$loopBody = other.getLoopBody();
            if (this$loopBody == null ? other$loopBody != null : !this$loopBody.equals(other$loopBody)) {
                return false;
            }
            Consumer<T> this$resultConsumer = this.getResultConsumer();
            Consumer<T> other$resultConsumer = other.getResultConsumer();
            if (this$resultConsumer == null ? other$resultConsumer != null : !this$resultConsumer.equals(other$resultConsumer)) {
                return false;
            }
            CompletableFuture<Void> this$result = this.getResult();
            CompletableFuture<Void> other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Executor this$executor = this.getExecutor();
            Executor other$executor = other.getExecutor();
            return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Loop;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Supplier<Boolean> $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
            Supplier<CompletableFuture<T>> $loopBody = this.getLoopBody();
            result = result * 59 + ($loopBody == null ? 43 : $loopBody.hashCode());
            Consumer<T> $resultConsumer = this.getResultConsumer();
            result = result * 59 + ($resultConsumer == null ? 43 : $resultConsumer.hashCode());
            CompletableFuture<Void> $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Executor $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Futures.Loop(condition=" + this.getCondition() + ", loopBody=" + this.getLoopBody() + ", resultConsumer=" + this.getResultConsumer() + ", result=" + this.getResult() + ", executor=" + this.getExecutor() + ")";
        }
    }
}

