/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class LatestItemSequentialProcessor<ItemType> {
    private final AtomicReference<ItemType> toProcess = new AtomicReference();
    private final Consumer<ItemType> processFunction;
    private final Executor executor;

    public LatestItemSequentialProcessor(Consumer<ItemType> processFunction, Executor executor) {
        this.processFunction = Preconditions.checkNotNull(processFunction);
        this.executor = Preconditions.checkNotNull(executor);
    }

    public void updateItem(ItemType newItem) {
        Preconditions.checkNotNull(newItem);
        if (this.toProcess.getAndSet(newItem) == null) {
            this.executor.execute(() -> {
                Object item = newItem;
                this.processFunction.accept(item);
                while (!this.toProcess.compareAndSet(item, null)) {
                    item = this.toProcess.get();
                    this.processFunction.accept(item);
                }
            });
        }
    }
}

