/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class Services {
    public static CompletableFuture<Void> startAsync(Service service, Executor executor) {
        Preconditions.checkState(service.state() == Service.State.NEW, "Service expected to be %s but was %s.", (Object)Service.State.NEW, (Object)service.state());
        Preconditions.checkNotNull(executor, "executor");
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        service.addListener(new StartupListener(result), executor);
        service.startAsync();
        return result;
    }

    public static CompletableFuture<Void> stopAsync(Service service, Executor executor) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Services.onStop(service, () -> result.complete(null), result::completeExceptionally, executor);
        service.stopAsync();
        return result;
    }

    public static void onStop(Service service, Runnable terminatedCallback, Consumer<Throwable> failureCallback, Executor executor) {
        ShutdownListener listener = new ShutdownListener(terminatedCallback, failureCallback);
        service.addListener(listener, executor);
        Service.State state = service.state();
        if (state == Service.State.FAILED) {
            listener.failed(Service.State.FAILED, service.failureCause());
        } else if (state == Service.State.TERMINATED) {
            listener.terminated(Service.State.TERMINATED);
        }
    }

    public static boolean isTerminating(Service.State state) {
        return state == Service.State.STOPPING || state == Service.State.TERMINATED || state == Service.State.FAILED;
    }

    private static class StartupListener
    extends Service.Listener {
        private final CompletableFuture<Void> completion;

        @Override
        public void running() {
            this.completion.complete(null);
        }

        @Override
        public void terminated(@Nonnull Service.State from) {
            this.completion.completeExceptionally(new IllegalStateException(String.format("Service expected to be %s but was %s.", new Object[]{Service.State.RUNNING, Service.State.TERMINATED})));
        }

        @Override
        public void failed(@Nonnull Service.State from, @Nonnull Throwable failure) {
            this.completion.completeExceptionally(failure);
        }

        @ConstructorProperties(value={"completion"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StartupListener(CompletableFuture<Void> completion) {
            this.completion = completion;
        }
    }

    private static class ShutdownListener
    extends Service.Listener {
        private final Runnable terminatedCallback;
        private final Consumer<Throwable> failureCallback;
        private final AtomicBoolean invoked = new AtomicBoolean(false);

        @Override
        public void terminated(@Nonnull Service.State from) {
            if (!this.invoked.compareAndSet(false, true)) {
                return;
            }
            if (this.terminatedCallback != null) {
                this.terminatedCallback.run();
            }
        }

        @Override
        public void failed(@Nonnull Service.State from, @Nonnull Throwable failure) {
            if (!this.invoked.compareAndSet(false, true)) {
                return;
            }
            if (this.failureCallback != null) {
                this.failureCallback.accept(failure);
            }
        }

        @ConstructorProperties(value={"terminatedCallback", "failureCallback"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ShutdownListener(Runnable terminatedCallback, Consumer<Throwable> failureCallback) {
            this.terminatedCallback = terminatedCallback;
            this.failureCallback = failureCallback;
        }
    }
}

