/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.hash;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.BufferView;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;

public class HashHelper {
    private static final long LEADING_BITS = 0x3FF0000000000000L;
    private static final long MASK = 0xFFFFFFFFFFFFFL;
    private HashFunction hash;

    private HashHelper(int seed) {
        this.hash = Hashing.murmur3_128(seed);
    }

    public static HashHelper seededWith(String seed) {
        return new HashHelper(seed.hashCode());
    }

    public int hash(long longNumber) {
        return this.hash.hashLong(longNumber).asInt();
    }

    public long hash(String str) {
        return this.hash.hashUnencodedChars(str).asLong();
    }

    public int hash(byte[] array, int offset, int length) {
        return this.hash.hashBytes(array, offset, length).asInt();
    }

    public UUID toUUID(String str) {
        assert (this.hash.bits() == 128);
        return HashHelper.bytesToUUID(this.hash.hashUnencodedChars(str).asBytes());
    }

    @VisibleForTesting
    static UUID bytesToUUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public int hashToBucket(String str, int numBuckets) {
        return Hashing.consistentHash(this.hash.hashUnencodedChars(str), numBuckets);
    }

    public int hashToBucket(UUID uuid, int numBuckets) {
        return Hashing.consistentHash(Hashing.combineOrdered(Arrays.asList(this.hash.hashLong(uuid.getMostSignificantBits()), this.hash.hashLong(uuid.getLeastSignificantBits()))), numBuckets);
    }

    public int hashToBucket(byte[] array, int numBuckets) {
        return Hashing.consistentHash(this.hash.hashBytes(array), numBuckets);
    }

    public int hashToBucket(BufferView bufferView, int numBuckets) {
        HashBuilder builder = this.newBuilder();
        bufferView.collect(builder::put);
        return Hashing.consistentHash(builder.getHashCode(), numBuckets);
    }

    public HashBuilder newBuilder() {
        return new HashBuilder(this.hash.newHasher());
    }

    public double hashToRange(String str) {
        return HashHelper.longToDoubleFraction(this.hash.hashUnencodedChars(str).asLong());
    }

    public double hashToRange(ByteBuffer ... bufs) {
        HashCode result;
        Preconditions.checkArgument(bufs.length > 0, "At least one buffer expected.");
        if (bufs.length == 1) {
            result = this.hash.hashBytes(bufs[0]);
        } else {
            Hasher h2 = this.hash.newHasher();
            for (ByteBuffer buf : bufs) {
                h2.putBytes(buf);
            }
            result = h2.hash();
        }
        return HashHelper.longToDoubleFraction(result.asLong());
    }

    @VisibleForTesting
    static double longToDoubleFraction(long value) {
        long shifted = value >> 12 & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(0x3FF0000000000000L + shifted) - 1.0;
    }

    public final class HashBuilder {
        private final Hasher hasher;

        public void put(ByteBuffer bb) {
            this.hasher.putBytes(bb);
        }

        private HashCode getHashCode() {
            return this.hasher.hash();
        }

        public int getAsInt() {
            return this.getHashCode().asInt();
        }

        @ConstructorProperties(value={"hasher"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private HashBuilder(Hasher hasher) {
            this.hasher = hasher;
        }
    }
}

