/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io;

import com.google.common.base.Preconditions;
import io.pravega.common.io.FixedByteArrayOutputStream;
import io.pravega.common.io.serialization.RandomAccessOutputStream;
import io.pravega.common.util.ByteArraySegment;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class EnhancedByteArrayOutputStream
extends ByteArrayOutputStream
implements RandomAccessOutputStream {
    public ByteArraySegment getData() {
        return new ByteArraySegment(this.buf, 0, this.count, true);
    }

    @Override
    public void write(byte[] array) {
        this.write(array, 0, array.length);
    }

    @Override
    public void write(int byteValue, int streamPosition) {
        Preconditions.checkElementIndex(streamPosition, this.buf.length, "streamPosition");
        this.buf[streamPosition] = (byte)byteValue;
    }

    @Override
    public void write(byte[] buffer, int bufferOffset, int length, int streamPosition) {
        if (bufferOffset < 0 || length < 0 || length > 0 && bufferOffset + length > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("bufferOffset and length must refer to a range within buffer.");
        }
        Preconditions.checkElementIndex(streamPosition, this.buf.length, "streamPosition");
        if (streamPosition + length <= this.buf.length) {
            System.arraycopy(buffer, bufferOffset, this.buf, streamPosition, length);
        } else {
            int splitPos = this.buf.length - streamPosition;
            System.arraycopy(buffer, bufferOffset, this.buf, streamPosition, splitPos);
            this.write(buffer, bufferOffset + splitPos, length - splitPos);
        }
    }

    @Override
    public OutputStream subStream(int streamPosition, int length) {
        return new FixedByteArrayOutputStream(this.buf, streamPosition, length);
    }
}

