/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.io.serialization.RandomAccessOutputStream;
import io.pravega.common.util.ByteArraySegment;
import java.io.IOException;
import java.io.OutputStream;

public class FixedByteArrayOutputStream
extends OutputStream
implements RandomAccessOutputStream {
    private final byte[] array;
    private final int offset;
    private final int length;
    private int position;
    private boolean isClosed;

    public FixedByteArrayOutputStream(byte[] array, int offset, int length) {
        Preconditions.checkNotNull(array, "array");
        Exceptions.checkArrayRange(offset, length, array.length, "offset", "length");
        this.array = array;
        this.offset = offset;
        this.length = length;
        this.position = 0;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IOException("OutputStream is closed.");
        }
        if (this.position >= this.length) {
            throw new IOException("Buffer capacity exceeded.");
        }
        this.array[this.offset + this.position] = (byte)b;
        ++this.position;
    }

    @Override
    public void write(int byteValue, int streamPosition) throws IOException {
        if (this.isClosed) {
            throw new IOException("OutputStream is closed.");
        }
        Preconditions.checkElementIndex(streamPosition += this.offset, this.array.length, "streamPosition");
        this.array[streamPosition] = (byte)byteValue;
    }

    @Override
    public void write(byte[] buffer, int bufferOffset, int length, int streamPosition) throws IOException {
        if (this.isClosed) {
            throw new IOException("OutputStream is closed.");
        }
        if (bufferOffset < 0 || length < 0 || length > 0 && bufferOffset + length > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("bufferOffset and length must refer to a range within buffer.");
        }
        if ((streamPosition += this.offset) + length > this.array.length) {
            throw new ArrayIndexOutOfBoundsException("streamPosition+length must refer to a position within the Stream array.");
        }
        System.arraycopy(buffer, bufferOffset, this.array, streamPosition, length);
    }

    @Override
    public OutputStream subStream(int streamPosition, int length) {
        return new FixedByteArrayOutputStream(this.array, this.offset + streamPosition, length);
    }

    @Override
    public int size() {
        return this.position;
    }

    public ByteArraySegment getData() {
        return new ByteArraySegment(this.array, this.offset, this.length, true);
    }

    @Override
    public void close() {
        this.isClosed = true;
    }
}

