/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.tracing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.tracing.RequestTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestTracker {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestTracker.class);
    private static final String INTER_FIELD_DELIMITER = "-";
    private static final int MAX_CACHE_SIZE = 1000000;
    private static final int EVICTION_PERIOD_MINUTES = 10;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Cache<String, List<Long>> ongoingRequests;
    private final boolean tracingEnabled;

    public RequestTracker(boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
        this.ongoingRequests = tracingEnabled ? CacheBuilder.newBuilder().maximumSize(1000000L).expireAfterWrite(10L, TimeUnit.MINUTES).build() : null;
    }

    public static String buildRequestDescriptor(String ... requestInfo) {
        return Stream.of(requestInfo).collect(Collectors.joining(INTER_FIELD_DELIMITER));
    }

    public RequestTag getRequestTagFor(String ... requestInfo) {
        return this.getRequestTagFor(RequestTracker.buildRequestDescriptor(requestInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestTag getRequestTagFor(String requestDescriptor) {
        long requestId;
        Preconditions.checkNotNull(requestDescriptor, "Attempting to get a null request descriptor.");
        if (!this.tracingEnabled) {
            return new RequestTag(requestDescriptor, 0L);
        }
        Object object = this.lock;
        synchronized (object) {
            List<Long> descriptorIds = this.ongoingRequests.getIfPresent(requestDescriptor);
            long l = requestId = descriptorIds == null || descriptorIds.size() == 0 ? 0L : descriptorIds.get(0);
            if (descriptorIds == null) {
                log.debug("Attempting to get a non-existing tag: {}.", (Object)requestDescriptor);
            } else if (descriptorIds.size() > 1) {
                log.debug("{} request ids associated with same descriptor: {}. Propagating only first one: {}.", descriptorIds, requestDescriptor, requestId);
            }
        }
        return new RequestTag(requestDescriptor, requestId);
    }

    public long getRequestIdFor(String ... requestInfo) {
        return this.getRequestIdFor(RequestTracker.buildRequestDescriptor(requestInfo));
    }

    public long getRequestIdFor(String requestDescriptor) {
        return this.getRequestTagFor(requestDescriptor).getRequestId();
    }

    public void trackRequest(RequestTag requestTag) {
        this.trackRequest(requestTag.getRequestDescriptor(), requestTag.getRequestId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackRequest(String requestDescriptor, long requestId) {
        Preconditions.checkNotNull(requestDescriptor, "Attempting to track a null request descriptor.");
        if (!this.tracingEnabled) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            List<Long> requestIds = this.ongoingRequests.getIfPresent(requestDescriptor);
            if (requestIds == null) {
                requestIds = Collections.synchronizedList(new ArrayList());
            }
            requestIds.add(requestId);
            this.ongoingRequests.put(requestDescriptor, requestIds);
        }
        log.debug("Tracking request {} with id {}.", (Object)requestDescriptor, (Object)requestId);
    }

    public long untrackRequest(RequestTag requestTag) {
        return this.untrackRequest(requestTag.getRequestDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long untrackRequest(String requestDescriptor) {
        long removedRequestId;
        List<Long> requestIds;
        Preconditions.checkNotNull(requestDescriptor, "Attempting to untrack a null request descriptor.");
        if (!this.tracingEnabled) {
            return 0L;
        }
        Object object = this.lock;
        synchronized (object) {
            requestIds = this.ongoingRequests.getIfPresent(requestDescriptor);
            if (requestIds == null || requestIds.size() == 0) {
                log.debug("Attempting to untrack a non-existing key: {}.", (Object)requestDescriptor);
                return 0L;
            }
            if (requestIds.size() > 1) {
                removedRequestId = requestIds.remove(requestIds.size() - 1);
                log.debug("{} concurrent requests with same descriptor: {}. Untracking the last of them {}.", requestIds, requestDescriptor, removedRequestId);
                this.ongoingRequests.put(requestDescriptor, requestIds);
            } else {
                this.ongoingRequests.invalidate(requestDescriptor);
                removedRequestId = requestIds.get(0);
            }
        }
        log.debug("Untracking request {} with id {}.", (Object)requestDescriptor, (Object)requestIds);
        return removedRequestId;
    }

    public RequestTag initializeAndTrackRequestTag(long requestId, String ... requestInfo) {
        RequestTag requestTag = this.getRequestTagFor(requestInfo);
        if (this.tracingEnabled && !requestTag.isTracked()) {
            log.debug("Tags not found for this request: requestId={}, descriptor={}. Create request tag at this point.", (Object)requestId, (Object)RequestTracker.buildRequestDescriptor(requestInfo));
            requestTag = new RequestTag(RequestTracker.buildRequestDescriptor(requestInfo), requestId);
            this.trackRequest(requestTag);
        }
        return requestTag;
    }

    @VisibleForTesting
    public long getNumDescriptors() {
        return this.ongoingRequests.size();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }
}

