/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import io.pravega.common.util.SortedIndex;
import java.util.ConcurrentModificationException;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AvlTreeIndex<V extends SortedIndex.IndexEntry>
implements SortedIndex<V> {
    private static final int MAX_IMBALANCE = 1;
    private transient Node root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private transient V first = null;
    private transient V last = null;

    @Override
    public void clear() {
        this.root = null;
        this.first = null;
        this.last = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public V put(V item) {
        Preconditions.checkNotNull(item, "item");
        UpdateResult result = this.insert(item, this.root);
        this.root = result.node;
        if (this.size == 1) {
            this.last = item;
            this.first = item;
        } else {
            if (this.first != null && this.first.key() >= item.key()) {
                this.first = item;
            }
            if (this.last != null && this.last.key() <= item.key()) {
                this.last = item;
            }
        }
        return result.updatedItem;
    }

    @Override
    public V remove(long key) {
        UpdateResult result = this.delete(key, this.root);
        this.root = result.node;
        if (result.updatedItem != null) {
            if (this.first != null && key <= this.first.key() || this.size == 0) {
                this.first = null;
            }
            if (this.last != null && key >= this.last.key() || this.size == 0) {
                this.last = null;
            }
        }
        return result.updatedItem;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(long key) {
        Node node = this.root;
        while (node != null) {
            long itemKey = node.item.key();
            if (key < itemKey) {
                node = node.left;
                continue;
            }
            if (key > itemKey) {
                node = node.right;
                continue;
            }
            return node.item;
        }
        return null;
    }

    @Override
    public V getCeiling(long key) {
        Node node = this.root;
        Node lastLeftChildParent = null;
        V result = null;
        while (node != null && result == null) {
            long itemKey = node.item.key();
            if (key < itemKey) {
                if (node.left == null) {
                    result = node.item;
                    continue;
                }
                lastLeftChildParent = node;
                node = node.left;
                continue;
            }
            if (key > itemKey) {
                node = node.right;
                if (node != null || lastLeftChildParent == null) continue;
                result = lastLeftChildParent.item;
                continue;
            }
            result = node.item;
        }
        return result;
    }

    @Override
    public V getFloor(long key) {
        Node node = this.root;
        Node lastRightChildParent = null;
        V result = null;
        while (node != null && result == null) {
            long itemKey = node.item.key();
            if (key > itemKey) {
                if (node.right == null) {
                    result = node.item;
                    continue;
                }
                lastRightChildParent = node;
                node = node.right;
                continue;
            }
            if (key < itemKey) {
                node = node.left;
                if (node != null || lastRightChildParent == null) continue;
                result = lastRightChildParent.item;
                continue;
            }
            result = node.item;
        }
        return result;
    }

    @Override
    public V getFirst() {
        if (this.first == null) {
            this.first = this.findSmallest(this.root);
        }
        return this.first;
    }

    @Override
    public V getLast() {
        if (this.last == null) {
            this.last = this.findLargest(this.root);
        }
        return this.last;
    }

    @Override
    public void forEach(Consumer<V> consumer) {
        Preconditions.checkNotNull(consumer, "consumer");
        TraversalStack stack = new TraversalStack(this.getHeight(this.root) + 1);
        Node node = this.root;
        int originalModCount = this.modCount;
        while (!stack.empty() || node != null) {
            if (originalModCount != this.modCount) {
                throw new ConcurrentModificationException("AvlTreeIndex has been modified; forEach cannot continue.");
            }
            if (node != null) {
                stack.push(node);
                node = node.left;
                continue;
            }
            Node nextNode = stack.pop();
            consumer.accept(nextNode.item);
            node = nextNode.right;
        }
    }

    private UpdateResult insert(V item, Node node) {
        UpdateResult result;
        if (node == null) {
            result = new UpdateResult();
            result.node = new Node(this, item);
            ++this.size;
            ++this.modCount;
        } else {
            long nodeKey;
            long itemKey = item.key();
            if (itemKey < (nodeKey = node.item.key())) {
                result = this.insert(item, node.left);
                node.left = result.node;
            } else if (itemKey > nodeKey) {
                result = this.insert(item, node.right);
                node.right = result.node;
            } else {
                result = new UpdateResult();
                result.updatedItem = node.item;
                node.item = item;
            }
            result.node = this.balance(node);
        }
        return result;
    }

    private UpdateResult delete(long key, Node node) {
        UpdateResult result;
        if (node == null) {
            result = new UpdateResult();
        } else {
            long itemKey = node.item.key();
            if (key < itemKey) {
                result = this.delete(key, node.left);
                node.left = result.node;
            } else if (key > itemKey) {
                result = this.delete(key, node.right);
                node.right = result.node;
            } else {
                result = new UpdateResult();
                result.updatedItem = node.item;
                if (node.left != null && node.right != null) {
                    node.item = this.findSmallest(node.right);
                    node.right = this.delete((long)node.item.key(), (Node)node.right).node;
                } else {
                    node = node.left != null ? node.left : node.right;
                    --this.size;
                    ++this.modCount;
                }
            }
            result.node = this.balance(node);
        }
        return result;
    }

    private Node balance(Node node) {
        if (node == null) {
            return null;
        }
        int imbalance = this.getHeight(node.left) - this.getHeight(node.right);
        if (imbalance > 1) {
            if (this.getHeight(node.left.left) < this.getHeight(node.left.right)) {
                node.left = this.rotateRight(node.left);
            }
            return this.rotateLeft(node);
        }
        if (-imbalance > 1) {
            if (this.getHeight(node.right.right) < this.getHeight(node.right.left)) {
                node.right = this.rotateLeft(node.right);
            }
            return this.rotateRight(node);
        }
        node.height = this.calculateHeight(this.getHeight(node.left), this.getHeight(node.right));
        return node;
    }

    private Node rotateLeft(Node node) {
        Node leftChild = node.left;
        node.left = leftChild.right;
        leftChild.right = node;
        node.height = this.calculateHeight(this.getHeight(node.left), this.getHeight(node.right));
        leftChild.height = this.calculateHeight(this.getHeight(leftChild.left), node.height);
        return leftChild;
    }

    private Node rotateRight(Node node) {
        Node rightChild = node.right;
        node.right = rightChild.left;
        rightChild.left = node;
        node.height = this.calculateHeight(this.getHeight(node.left), this.getHeight(node.right));
        rightChild.height = this.calculateHeight(this.getHeight(rightChild.right), node.height);
        return rightChild;
    }

    private byte getHeight(Node node) {
        return node == null ? (byte)-1 : (byte)node.height;
    }

    private byte calculateHeight(byte leftHeight, byte rightHeight) {
        return (byte)((leftHeight >= rightHeight ? leftHeight : rightHeight) + 1);
    }

    private V findSmallest(Node node) {
        if (node == null) {
            return null;
        }
        while (node.left != null) {
            node = node.left;
        }
        return node.item;
    }

    private V findLargest(Node node) {
        if (node == null) {
            return null;
        }
        while (node.right != null) {
            node = node.right;
        }
        return node.item;
    }

    private class TraversalStack {
        private final Object[] nodes;
        private int size;

        TraversalStack(int maxSize) {
            this.nodes = new Object[maxSize];
            this.size = 0;
        }

        void push(Node node) {
            this.nodes[this.size++] = node;
        }

        Node pop() {
            return (Node)this.nodes[--this.size];
        }

        boolean empty() {
            return this.size == 0;
        }
    }

    private class UpdateResult {
        Node node;
        V updatedItem;

        private UpdateResult() {
        }
    }

    private static class Node {
        V item;
        Node left;
        Node right;
        byte height;
        final /* synthetic */ AvlTreeIndex this$0;

        Node(V item) {
            this.this$0 = var1_1;
            this.item = item;
        }

        public String toString() {
            return String.format("%s, Left = %s, Right = %s", this.item.toString(), this.left == null ? "" : this.left.item, this.right == null ? "" : this.right.item);
        }
    }
}

