/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import java.util.ArrayDeque;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BlockingDrainingQueue<T> {
    @GuardedBy(value="contents")
    private final ArrayDeque<T> contents = new ArrayDeque();
    @GuardedBy(value="contents")
    private CompletableFuture<Queue<T>> pendingTake;
    @GuardedBy(value="contents")
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<T> close() {
        CompletableFuture<Queue<T>> pending = null;
        Queue<Object> result = null;
        ArrayDeque<T> arrayDeque = this.contents;
        synchronized (arrayDeque) {
            if (!this.closed) {
                this.closed = true;
                pending = this.pendingTake;
                this.pendingTake = null;
                result = this.fetch(this.contents.size());
            }
        }
        if (pending != null) {
            pending.cancel(true);
        }
        return result != null ? result : new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPendingTake() {
        CompletableFuture<Queue<T>> pending;
        ArrayDeque<T> arrayDeque = this.contents;
        synchronized (arrayDeque) {
            pending = this.pendingTake;
            this.pendingTake = null;
        }
        if (pending != null) {
            pending.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T item) {
        CompletableFuture<Queue<Queue<T>>> pending;
        Queue<T> result = null;
        ArrayDeque<T> arrayDeque = this.contents;
        synchronized (arrayDeque) {
            Exceptions.checkNotClosed(this.closed, this);
            this.contents.addLast(item);
            pending = this.pendingTake;
            this.pendingTake = null;
            if (pending != null) {
                result = this.fetch(this.contents.size());
            }
        }
        if (pending != null) {
            pending.complete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<T> poll(int maxCount) {
        ArrayDeque<T> arrayDeque = this.contents;
        synchronized (arrayDeque) {
            Exceptions.checkNotClosed(this.closed, this);
            Preconditions.checkState(this.pendingTake == null, "Cannot call poll() when there is a pending take() request.");
            return this.fetch(maxCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Queue<T>> take(int maxCount) {
        ArrayDeque<T> arrayDeque = this.contents;
        synchronized (arrayDeque) {
            Exceptions.checkNotClosed(this.closed, this);
            Preconditions.checkState(this.pendingTake == null, "Cannot have more than one concurrent pending take() request.");
            Queue<T> result = this.fetch(maxCount);
            if (result.size() > 0) {
                return CompletableFuture.completedFuture(result);
            }
            this.pendingTake = new CompletableFuture();
            return this.pendingTake;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayDeque<T> arrayDeque = this.contents;
        synchronized (arrayDeque) {
            return this.contents.size();
        }
    }

    @GuardedBy(value="contents")
    private Queue<T> fetch(int maxCount) {
        int count = Math.min(maxCount, this.contents.size());
        ArrayDeque<T> result = new ArrayDeque<T>(count);
        while (result.size() < count) {
            result.addLast(this.contents.pollFirst());
        }
        return result;
    }
}

