/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import java.io.Serializable;
import java.util.Comparator;

public final class ByteArrayComparator
implements Comparator<byte[]>,
Serializable {
    public static final byte MIN_VALUE = 0;
    public static final byte MAX_VALUE = -1;
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(byte[] b1, byte[] b2) {
        assert (b1.length == b2.length);
        return this.compare(b1, 0, b2, 0, b1.length);
    }

    @Override
    public int compare(ArrayView b1, ArrayView b2) {
        if (b1.getLength() == b2.getLength()) {
            return this.compare(b1.array(), b1.arrayOffset(), b2.array(), b2.arrayOffset(), b1.getLength());
        }
        int len = Math.min(b1.getLength(), b2.getLength());
        int c = this.compare(b1.array(), b1.arrayOffset(), b2.array(), b2.arrayOffset(), len);
        if (c == 0) {
            c = b2.getLength() > b1.getLength() ? -1 : 1;
        }
        return c;
    }

    @Override
    @VisibleForTesting
    public int compare(BufferView b1, BufferView b2) {
        if (b1 instanceof ArrayView && b2 instanceof ArrayView) {
            return this.compare((ArrayView)b1, (ArrayView)b2);
        }
        BufferView.Reader r1 = b1.getBufferViewReader();
        BufferView.Reader r2 = b2.getBufferViewReader();
        while (r1.available() > 0 && r2.available() > 0) {
            int r = (r1.readByte() & 0xFF) - (r2.readByte() & 0xFF);
            if (r == 0) continue;
            return r;
        }
        if (r1.available() == r2.available()) {
            return 0;
        }
        return r2.available() > 0 ? -1 : 1;
    }

    public int compare(byte[] b1, int offset1, byte[] b2, int offset2, int length) {
        for (int i = 0; i < length; ++i) {
            int r = (b1[offset1 + i] & 0xFF) - (b2[offset2 + i] & 0xFF);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    public static byte[] getMinValue() {
        return new byte[]{0};
    }

    public static ArrayView getNextItemOfSameLength(ArrayView array) {
        int maxValue = 255;
        byte[] result = new byte[array.getLength()];
        array.copyTo(result, 0, result.length);
        for (int index = result.length - 1; index >= 0; --index) {
            int v = result[index] & 0xFF;
            if (v < 255) {
                result[index] = (byte)(v + 1);
                return new ByteArraySegment(result);
            }
            result[index] = 0;
        }
        return null;
    }
}

