/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.io.FixedByteArrayOutputStream;
import io.pravega.common.util.AbstractBufferView;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.BitConverter;
import io.pravega.common.util.BufferView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ByteArraySegment
extends AbstractBufferView
implements ArrayView {
    private final byte[] array;
    private final int startOffset;
    private final int length;
    private final boolean readOnly;

    public ByteArraySegment(byte[] array) {
        this(array, 0, array.length);
    }

    public ByteArraySegment(byte[] array, int startOffset, int length) {
        this(array, startOffset, length, false);
    }

    public ByteArraySegment(ByteBuffer buff) {
        this(buff.array(), buff.arrayOffset() + buff.position(), buff.remaining(), false);
    }

    public ByteArraySegment(byte[] array, int startOffset, int length, boolean readOnly) {
        Preconditions.checkNotNull(array, "array");
        Exceptions.checkArrayRange(startOffset, length, array.length, "startOffset", "length");
        this.array = array;
        this.startOffset = startOffset;
        this.length = length;
        this.readOnly = readOnly;
    }

    @Override
    public byte get(int index) {
        Preconditions.checkElementIndex(index, this.length, "index");
        return this.array[index + this.startOffset];
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] array() {
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return this.startOffset;
    }

    @Override
    public Reader getBufferViewReader() {
        return new Reader();
    }

    @Override
    public InputStream getReader() {
        return new ByteArrayInputStream(this.array, this.startOffset, this.length);
    }

    @Override
    public InputStream getReader(int offset, int length) {
        Exceptions.checkArrayRange(offset, length, this.length, "offset", "length");
        return new ByteArrayInputStream(this.array, this.startOffset + offset, length);
    }

    @Override
    public ByteArraySegment slice(int offset, int length) {
        return this.subSegment(offset, length, this.readOnly);
    }

    @Override
    public byte[] getCopy() {
        byte[] buffer = new byte[this.length];
        System.arraycopy(this.array, this.startOffset, buffer, 0, this.length);
        return buffer;
    }

    @Override
    public void copyTo(byte[] target, int targetOffset, int length) {
        Preconditions.checkElementIndex(length, this.length + 1, "length");
        Exceptions.checkArrayRange(targetOffset, length, target.length, "index", "values.length");
        System.arraycopy(this.array, this.startOffset, target, targetOffset, length);
    }

    @Override
    public int copyTo(ByteBuffer target) {
        int length = Math.min(this.length, target.remaining());
        target.put(this.array, this.startOffset, length);
        return length;
    }

    @Override
    public void copyTo(OutputStream stream) throws IOException {
        stream.write(this.array, this.startOffset, this.length);
    }

    @Override
    public boolean equals(BufferView other) {
        if (this.length != other.getLength()) {
            return false;
        }
        if (other instanceof ArrayView) {
            return this.equals((ArrayView)other);
        }
        InputStream otherReader = other.getReader();
        for (int i = 0; i < this.length; ++i) {
            if ((byte)otherReader.read() == this.array[this.startOffset + i]) continue;
            return false;
        }
        return true;
    }

    private boolean equals(ArrayView other) {
        if (this.length != other.getLength()) {
            return false;
        }
        byte[] otherArray = other.array();
        int otherOffset = other.arrayOffset();
        for (int i = 0; i < this.length; ++i) {
            if (this.array[this.startOffset + i] == otherArray[otherOffset + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public <ExceptionT extends Exception> void collect(BufferView.Collector<ExceptionT> bufferCollector) throws ExceptionT {
        bufferCollector.accept(ByteBuffer.wrap(this.array, this.startOffset, this.length));
    }

    public void set(int index, byte value) {
        Preconditions.checkState(!this.readOnly, "Cannot modify a read-only ByteArraySegment.");
        Preconditions.checkElementIndex(index, this.length, "index");
        this.array[index + this.startOffset] = value;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void copyFrom(ByteArraySegment source, int targetOffset, int length) {
        Preconditions.checkState(!this.readOnly, "Cannot modify a read-only ByteArraySegment.");
        Exceptions.checkArrayRange(targetOffset, length, this.length, "index", "values.length");
        Preconditions.checkElementIndex(length, source.getLength() + 1, "length");
        System.arraycopy(source.array, source.startOffset, this.array, targetOffset + this.startOffset, length);
    }

    public void copyFrom(ByteArraySegment source, int sourceOffset, int targetOffset, int length) {
        Preconditions.checkState(!this.readOnly, "Cannot modify a read-only ByteArraySegment.");
        Exceptions.checkArrayRange(sourceOffset, length, source.length, "index", "values.length");
        Exceptions.checkArrayRange(targetOffset, length, this.length, "index", "values.length");
        Preconditions.checkElementIndex(length, source.getLength() + 1, "length");
        System.arraycopy(source.array, source.startOffset + sourceOffset, this.array, this.startOffset + targetOffset, length);
    }

    public OutputStream getWriter() {
        Preconditions.checkState(!this.readOnly, "Cannot modify a read-only ByteArraySegment.");
        return new FixedByteArrayOutputStream(this.array, this.startOffset, this.length);
    }

    public ByteArraySegment subSegment(int offset, int length, boolean readOnly) {
        Exceptions.checkArrayRange(offset, length, this.length, "offset", "length");
        return new ByteArraySegment(this.array, this.startOffset + offset, length, readOnly || this.readOnly);
    }

    public String toString() {
        if (this.getLength() > 128) {
            return String.format("Length = %s", this.getLength());
        }
        return String.format("{%s}", IntStream.range(this.arrayOffset(), this.arrayOffset() + this.getLength()).boxed().map(i -> Byte.toString(this.array[i])).collect(Collectors.joining(",")));
    }

    private class Reader
    extends AbstractBufferView.AbstractReader
    implements BufferView.Reader {
        private int position = 0;

        private Reader() {
        }

        @Override
        public int available() {
            return ByteArraySegment.this.length - this.position;
        }

        @Override
        public int readBytes(ByteArraySegment segment) {
            int len = Math.min(this.available(), segment.getLength());
            System.arraycopy(ByteArraySegment.this.array(), ByteArraySegment.this.arrayOffset() + this.position, segment.array(), segment.arrayOffset(), len);
            this.position += len;
            return len;
        }

        @Override
        public byte readByte() {
            if (this.position >= ByteArraySegment.this.length) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
            byte result = ByteArraySegment.this.array[ByteArraySegment.this.startOffset + this.position];
            ++this.position;
            return result;
        }

        @Override
        public int readInt() {
            int nextPos = this.position + 4;
            if (nextPos > ByteArraySegment.this.length) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
            int r = BitConverter.readInt(ByteArraySegment.this.array, ByteArraySegment.this.startOffset + this.position);
            this.position = nextPos;
            return r;
        }

        @Override
        public long readLong() {
            int nextPos = this.position + 8;
            if (nextPos > ByteArraySegment.this.length) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
            long r = BitConverter.readLong(ByteArraySegment.this.array, ByteArraySegment.this.startOffset + this.position);
            this.position = nextPos;
            return r;
        }

        @Override
        public BufferView readSlice(int length) {
            try {
                ByteArraySegment result = ByteArraySegment.this.slice(this.position, length);
                this.position += length;
                return result;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }
    }
}

