/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.AbstractBufferView;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

class CompositeBufferView
extends AbstractBufferView
implements BufferView {
    private final List<BufferView> components;
    private final int length;

    CompositeBufferView(@NonNull List<BufferView> components) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        this.components = new ArrayList<BufferView>();
        int length = 0;
        for (BufferView c : components) {
            if (c instanceof CompositeBufferView) {
                for (BufferView b : ((CompositeBufferView)c).components) {
                    this.components.add(b.slice());
                }
            } else {
                this.components.add(c.slice());
            }
            length += c.getLength();
        }
        this.length = length;
    }

    @Override
    public Reader getBufferViewReader() {
        return new Reader(this.components.stream().map(BufferView::getBufferViewReader).iterator(), this.getLength());
    }

    @Override
    public InputStream getReader() {
        return new SequenceInputStream(Iterators.asEnumeration(this.components.stream().map(BufferView::getReader).iterator()));
    }

    @Override
    public InputStream getReader(int offset, int length) {
        return this.slice(offset, length).getReader();
    }

    @Override
    public BufferView slice(int offset, int length) {
        Preconditions.checkArgument(offset >= 0 && length >= 0 && offset + length <= this.length, "offset and length must be non-negative and less than %s. Given %s-%s", (Object)this.length, (Object)offset, (Object)length);
        if (offset == 0 && length == this.length) {
            return this;
        }
        ArrayList<BufferView> components = new ArrayList<BufferView>(this.components.size());
        int index = 0;
        int currentOffset = 0;
        while (length > 0) {
            BufferView c = this.components.get(index);
            int lastComponentOffset = currentOffset + c.getLength();
            if (offset < lastComponentOffset) {
                int sliceStart = Math.max(0, offset - currentOffset);
                int sliceLength = Math.min(length, c.getLength() - sliceStart);
                components.add(c.slice(sliceStart, sliceLength));
                length -= sliceLength;
            }
            ++index;
            currentOffset += c.getLength();
        }
        return BufferView.wrap(components);
    }

    @Override
    public byte[] getCopy() {
        byte[] result = new byte[this.getLength()];
        int offset = 0;
        for (BufferView c : this.components) {
            int copiedBytes = c.copyTo(ByteBuffer.wrap(result, offset, c.getLength()));
            assert (copiedBytes == c.getLength());
            offset += copiedBytes;
        }
        return result;
    }

    @Override
    public void copyTo(OutputStream target) throws IOException {
        for (BufferView c : this.components) {
            c.copyTo(target);
        }
    }

    @Override
    public int copyTo(ByteBuffer target) {
        int bytesCopied = 0;
        for (BufferView c : this.components) {
            bytesCopied += c.copyTo(target);
        }
        return bytesCopied;
    }

    @Override
    public List<ByteBuffer> getContents() {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>(this.components.size());
        for (BufferView c : this.components) {
            result.addAll(c.getContents());
        }
        return result;
    }

    @Override
    public <ExceptionT extends Exception> void collect(BufferView.Collector<ExceptionT> bufferCollector) throws ExceptionT {
        for (BufferView bv : this.components) {
            bv.collect(bufferCollector);
        }
    }

    @Override
    public void retain() {
        this.components.forEach(BufferView::retain);
    }

    @Override
    public void release() {
        this.components.forEach(BufferView::release);
    }

    List<BufferView> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    @ConstructorProperties(value={"components", "length"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    CompositeBufferView(List<BufferView> components, int length) {
        this.components = components;
        this.length = length;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getLength() {
        return this.length;
    }

    private static class Reader
    extends AbstractBufferView.AbstractReader
    implements BufferView.Reader {
        private final Iterator<BufferView.Reader> readers;
        private BufferView.Reader current;
        private int available;

        Reader(Iterator<BufferView.Reader> readers, int available) {
            this.readers = readers;
            this.available = available;
        }

        @Override
        public int available() {
            return this.available;
        }

        @Override
        public int readBytes(ByteArraySegment segment) {
            BufferView.Reader current = this.getCurrent();
            if (current != null) {
                int len = current.readBytes(segment);
                this.available -= len;
                assert (this.available >= 0);
                return len;
            }
            return 0;
        }

        @Override
        public byte readByte() {
            BufferView.Reader current = this.getCurrent();
            if (current == null) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
            byte result = current.readByte();
            --this.available;
            assert (this.available >= 0);
            return result;
        }

        @Override
        public int readInt() {
            BufferView.Reader current = this.getCurrent();
            if (current != null && current.available() >= 4) {
                this.available -= 4;
                return current.readInt();
            }
            return super.readInt();
        }

        @Override
        public long readLong() {
            BufferView.Reader current = this.getCurrent();
            if (current != null && current.available() >= 8) {
                this.available -= 8;
                return current.readLong();
            }
            return super.readLong();
        }

        @Override
        public BufferView readSlice(int length) {
            int currentLength;
            if (length > this.available()) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
            if (length == 0) {
                return BufferView.empty();
            }
            ArrayList<BufferView> components = new ArrayList<BufferView>();
            for (int remaining = length; remaining > 0; remaining -= currentLength) {
                BufferView.Reader current = this.getCurrent();
                assert (current != null);
                currentLength = Math.min(current.available(), remaining);
                components.add(current.readSlice(currentLength));
                this.available -= currentLength;
            }
            assert (!components.isEmpty());
            assert (this.available >= 0);
            return new CompositeBufferView(components, length);
        }

        private BufferView.Reader getCurrent() {
            if (this.current == null || this.current.available() == 0) {
                this.current = this.readers.hasNext() ? this.readers.next() : null;
            }
            return this.current;
        }
    }
}

