/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.util.AbstractBufferView;
import io.pravega.common.util.BitConverter;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.CompositeArrayView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

public class CompositeByteArraySegment
extends AbstractBufferView
implements CompositeArrayView {
    private static final int DEFAULT_ARRAY_SIZE = 4096;
    private final int startOffset;
    private final int arraySize;
    private final Object[] arrays;
    private final int length;

    public CompositeByteArraySegment(int length) {
        this(length, 4096);
    }

    public CompositeByteArraySegment(int length, int arraySize) {
        Preconditions.checkArgument(length >= 0, "length must be a non-negative number.");
        Preconditions.checkArgument(arraySize > 0, "arraySize must be a positive number.");
        this.length = length;
        this.arraySize = Math.min(length, arraySize);
        this.startOffset = 0;
        int count = length / arraySize + (length % arraySize == 0 ? 0 : 1);
        this.arrays = new Object[count];
    }

    @VisibleForTesting
    public CompositeByteArraySegment(@NonNull byte[] source) {
        this(new Object[]{source}, source.length, 0, source.length);
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
    }

    private CompositeByteArraySegment(Object[] arrays, int arraySize, int startOffset, int length) {
        this.arrays = arrays;
        this.arraySize = arraySize;
        this.startOffset = startOffset;
        this.length = length;
    }

    @Override
    public byte get(int offset) {
        byte[] array = this.getArray(this.getArrayId(offset), false);
        return array == null ? (byte)0 : array[this.getArrayOffset(offset)];
    }

    @Override
    public void set(int offset, byte value) {
        byte[] array = this.getArray(this.getArrayId(offset), true);
        array[this.getArrayOffset((int)offset)] = value;
    }

    @Override
    public CompositeReader getBufferViewReader() {
        return new CompositeReader();
    }

    @Override
    public InputStream getReader() {
        ArrayList streams = new ArrayList();
        this.collect((array, offset, length) -> streams.add(new ByteArrayInputStream(array, offset, length)), this.length);
        return new SequenceInputStream(Iterators.asEnumeration(streams.iterator()));
    }

    @Override
    public InputStream getReader(int offset, int length) {
        return this.slice(offset, length).getReader();
    }

    @Override
    public CompositeArrayView slice(int offset, int length) {
        Exceptions.checkArrayRange(offset, length, this.length, "offset", "length");
        if (offset == 0 && length == this.length) {
            return this;
        }
        return new CompositeByteArraySegment(this.arrays, this.arraySize, this.startOffset + offset, length);
    }

    @Override
    public <ExceptionT extends Exception> void collect(BufferView.Collector<ExceptionT> bufferCollector) throws ExceptionT {
        this.collect((array, offset, len) -> bufferCollector.accept(ByteBuffer.wrap(array, offset, len)), this.length);
    }

    private <ExceptionT extends Exception> void collect(ArrayCollector<ExceptionT> collectArray, int length) throws ExceptionT {
        if (length == 0) {
            return;
        }
        int startId = this.getArrayId(0);
        int endId = this.getArrayId(length - 1);
        int arrayOffset = this.getArrayOffset(0);
        for (int arrayId = startId; arrayId <= endId; ++arrayId) {
            int arrayLength = Math.min(length, this.arraySize - arrayOffset);
            byte[] array = this.getArray(arrayId, false);
            if (array == null) {
                collectArray.accept(new byte[arrayLength], 0, arrayLength);
            } else {
                collectArray.accept(array, arrayOffset, arrayLength);
            }
            length -= arrayLength;
            arrayOffset = 0;
        }
        assert (length == 0) : "Collection finished but " + length + " bytes remaining";
    }

    @Override
    public int getComponentCount() {
        return this.length == 0 ? 0 : (this.startOffset + this.length - 1) / this.arraySize - this.startOffset / this.arraySize + 1;
    }

    @Override
    public byte[] getCopy() {
        byte[] result = new byte[this.length];
        this.copyTo(ByteBuffer.wrap(result));
        return result;
    }

    @Override
    public void copyFrom(BufferView.Reader source, int targetOffset, int length) {
        Preconditions.checkArgument(length <= source.available(), "length exceeds source input's length.");
        Exceptions.checkArrayRange(targetOffset, length, this.length, "offset", "length");
        int arrayOffset = this.getArrayOffset(targetOffset);
        int arrayId = this.getArrayId(targetOffset);
        int ol = length;
        while (length > 0) {
            byte[] array = this.getArray(arrayId, true);
            int copyLength = Math.min(array.length - arrayOffset, length);
            copyLength = source.readBytes(new ByteArraySegment(array, arrayOffset, copyLength));
            length -= copyLength;
            if ((arrayOffset += copyLength) < array.length) continue;
            ++arrayId;
            arrayOffset = 0;
        }
    }

    @Override
    public void copyTo(OutputStream target) throws IOException {
        this.collect(target::write, this.length);
    }

    @Override
    public int copyTo(ByteBuffer target) {
        int length = Math.min(this.length, target.remaining());
        this.collect(target::put, length);
        return length;
    }

    @Override
    public List<ByteBuffer> getContents() {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (int i = 0; i < this.arrays.length; ++i) {
            byte[] a = this.getArray(i, false);
            if (a == null) {
                int size = i == this.arrays.length - 1 ? this.length % this.arraySize : this.arraySize;
                result.add(ByteBuffer.allocate(size));
                continue;
            }
            result.add(ByteBuffer.wrap(a));
        }
        return result;
    }

    @VisibleForTesting
    int getAllocatedArrayCount() {
        return (int)Arrays.stream(this.arrays).filter(Objects::nonNull).count();
    }

    private int getArrayOffset(int offset) {
        return (this.startOffset + offset) % this.arraySize;
    }

    private int getArrayId(int offset) {
        Preconditions.checkElementIndex(offset, this.length, "offset");
        return (this.startOffset + offset) / this.arraySize;
    }

    private byte[] getArray(int arrayId, boolean allocate) {
        Object a = this.arrays[arrayId];
        if (a == null && allocate) {
            this.arrays[arrayId] = a = (Object)new byte[this.arraySize];
        }
        return (byte[])a;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getLength() {
        return this.length;
    }

    @FunctionalInterface
    private static interface ArrayCollector<ExceptionT extends Exception> {
        public void accept(byte[] var1, int var2, int var3) throws ExceptionT;
    }

    private class CompositeReader
    extends AbstractBufferView.AbstractReader
    implements BufferView.Reader {
        private int position = 0;

        private CompositeReader() {
        }

        @Override
        public int available() {
            return CompositeByteArraySegment.this.length - this.position;
        }

        @Override
        public int readBytes(ByteArraySegment segment) {
            int len = Math.min(this.available(), segment.getLength());
            if (len > 0) {
                CompositeByteArraySegment.this.slice(this.position, len).copyTo(ByteBuffer.wrap(segment.array(), segment.arrayOffset(), len));
                this.position += len;
            }
            return len;
        }

        @Override
        public byte readByte() {
            try {
                return CompositeByteArraySegment.this.get(this.position++);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }

        @Override
        public int readInt() {
            int arrayPos = CompositeByteArraySegment.this.getArrayOffset(this.position);
            if (CompositeByteArraySegment.this.arraySize - arrayPos >= 4) {
                int nextPos = this.position + 4;
                if (nextPos > CompositeByteArraySegment.this.length) {
                    throw new BufferView.Reader.OutOfBoundsException();
                }
                byte[] array = CompositeByteArraySegment.this.getArray(CompositeByteArraySegment.this.getArrayId(this.position), false);
                int r = array == null ? 0 : BitConverter.readInt(array, arrayPos);
                this.position = nextPos;
                return r;
            }
            return super.readInt();
        }

        @Override
        public long readLong() {
            int arrayPos = CompositeByteArraySegment.this.getArrayOffset(this.position);
            if (CompositeByteArraySegment.this.arraySize - arrayPos >= 8) {
                int nextPos = this.position + 8;
                if (nextPos > CompositeByteArraySegment.this.length) {
                    throw new BufferView.Reader.OutOfBoundsException();
                }
                byte[] array = CompositeByteArraySegment.this.getArray(CompositeByteArraySegment.this.getArrayId(this.position), false);
                long r = array == null ? 0L : BitConverter.readLong(array, arrayPos);
                this.position = nextPos;
                return r;
            }
            return super.readLong();
        }

        @Override
        public BufferView readSlice(int length) {
            try {
                CompositeArrayView result = CompositeByteArraySegment.this.slice(this.position, length);
                this.position += length;
                return result;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }
    }
}

