/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;

public class ResourcePool<T> {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final ArrayDeque<T> idleResources;
    @GuardedBy(value="lock")
    private boolean isRunning;
    @GuardedBy(value="lock")
    private final ArrayDeque<WaitingRequest<T>> waitQueue;
    @GuardedBy(value="lock")
    private int resourceCount;
    private final int maxConcurrent;
    private final int maxIdle;
    private final Listener listener;
    private final Supplier<CompletableFuture<T>> tSupplier;
    private final Consumer<T> tDestroyer;

    public ResourcePool(Supplier<CompletableFuture<T>> tSupplier, Consumer<T> tDestroyer, int maxConcurrent, int maxIdle) {
        this(tSupplier, tDestroyer, maxConcurrent, maxIdle, null);
    }

    @VisibleForTesting
    ResourcePool(Supplier<CompletableFuture<T>> tSupplier, Consumer<T> tDestroyer, int maxConcurrent, int maxIdle, Listener listener) {
        Preconditions.checkNotNull(tSupplier);
        Preconditions.checkNotNull(tDestroyer);
        Preconditions.checkArgument(maxConcurrent >= maxIdle);
        Preconditions.checkArgument(maxIdle >= 0);
        this.idleResources = new ArrayDeque();
        this.isRunning = true;
        this.waitQueue = new ArrayDeque();
        this.resourceCount = 0;
        this.maxConcurrent = maxConcurrent;
        this.maxIdle = maxIdle;
        this.listener = listener;
        this.tSupplier = tSupplier;
        this.tDestroyer = tDestroyer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<CloseableResource<T>> getResource() {
        CompletableFuture future;
        boolean tryCreateNewResource = false;
        Object object = this.lock;
        synchronized (object) {
            T t = this.idleResources.poll();
            if (t != null) {
                future = CompletableFuture.completedFuture(new CloseableResource(t, this));
            } else {
                future = new CompletableFuture();
                WaitingRequest request = new WaitingRequest(future);
                this.waitQueue.add(request);
                tryCreateNewResource = true;
            }
        }
        if (tryCreateNewResource) {
            this.tryCreateNewResource();
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnResource(T t, boolean isValid) {
        if (!isValid) {
            this.handleInvalid(t);
        } else {
            WaitingRequest<T> waiting;
            boolean toDestroy = false;
            Object object = this.lock;
            synchronized (object) {
                waiting = this.waitQueue.poll();
                if (waiting == null) {
                    if (!this.isRunning) {
                        --this.resourceCount;
                        toDestroy = true;
                    } else if (this.idleResources.size() < this.maxIdle) {
                        this.idleResources.offer(t);
                    } else {
                        --this.resourceCount;
                        toDestroy = true;
                    }
                }
            }
            if (waiting != null) {
                ((WaitingRequest)waiting).future.complete(new CloseableResource(t, this));
            }
            if (toDestroy) {
                if (this.listener != null) {
                    this.listener.notify(Event.Destroyed);
                }
                this.tDestroyer.accept(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCreateNewResource() {
        WaitingRequest<T> waiting;
        Object object = this.lock;
        synchronized (object) {
            if (this.resourceCount < this.maxConcurrent) {
                waiting = this.waitQueue.poll();
                if (waiting != null) {
                    ++this.resourceCount;
                }
            } else {
                waiting = null;
            }
        }
        if (waiting != null) {
            try {
                this.tSupplier.get().whenComplete((t, e) -> {
                    if (e != null) {
                        ((WaitingRequest)waiting).future.completeExceptionally((Throwable)e);
                    } else {
                        if (this.listener != null) {
                            this.listener.notify(Event.Created);
                        }
                        ((WaitingRequest)waiting).future.complete(new CloseableResource(t, this));
                    }
                });
            }
            catch (Throwable e2) {
                ((WaitingRequest)waiting).future.completeExceptionally(e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInvalid(T t) {
        boolean tryCreateNewresource;
        this.tDestroyer.accept(t);
        if (this.listener != null) {
            this.listener.notify(Event.Destroyed);
        }
        Object object = this.lock;
        synchronized (object) {
            --this.resourceCount;
            tryCreateNewresource = !this.waitQueue.isEmpty();
        }
        if (tryCreateNewresource) {
            this.tryCreateNewResource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int resourceCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.resourceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int idleCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.idleResources.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int waitingCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.waitQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        T t;
        Object object = this.lock;
        synchronized (object) {
            this.isRunning = false;
            t = this.idleResources.poll();
        }
        while (t != null) {
            this.returnResource(t, true);
            object = this.lock;
            synchronized (object) {
                t = this.idleResources.poll();
            }
        }
    }

    public static class CloseableResource<T>
    implements AutoCloseable {
        private final ResourcePool<T> resourcePool;
        private final T resource;
        private final AtomicBoolean invalid;
        private AtomicBoolean isClosed;

        private CloseableResource(T resource, ResourcePool<T> resourcePool) {
            this.resourcePool = resourcePool;
            this.resource = resource;
            this.invalid = new AtomicBoolean(false);
            this.isClosed = new AtomicBoolean(false);
        }

        public T getResource() {
            return this.resource;
        }

        public void invalidate() {
            this.invalid.set(true);
        }

        @Override
        public void close() {
            if (this.isClosed.compareAndSet(false, true)) {
                ((ResourcePool)this.resourcePool).returnResource(this.resource, !this.invalid.get());
            }
        }
    }

    private static class WaitingRequest<T> {
        private final CompletableFuture<CloseableResource<T>> future;

        @ConstructorProperties(value={"future"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WaitingRequest(CompletableFuture<CloseableResource<T>> future) {
            this.future = future;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CompletableFuture<CloseableResource<T>> getFuture() {
            return this.future;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WaitingRequest)) {
                return false;
            }
            WaitingRequest other = (WaitingRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CompletableFuture<CloseableResource<T>> this$future = this.getFuture();
            CompletableFuture<CloseableResource<T>> other$future = other.getFuture();
            return !(this$future == null ? other$future != null : !this$future.equals(other$future));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WaitingRequest;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CompletableFuture<CloseableResource<T>> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ResourcePool.WaitingRequest(future=" + this.getFuture() + ")";
        }
    }

    static enum Event {
        Created,
        Destroyed;

    }

    @VisibleForTesting
    static class Listener {
        private final LinkedBlockingQueue<Event> eventQueue;

        Listener(LinkedBlockingQueue<Event> eventQueue) {
            Preconditions.checkNotNull(eventQueue);
            this.eventQueue = eventQueue;
        }

        public void notify(Event event) {
            this.eventQueue.offer(event);
        }
    }
}

