/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;

@ThreadSafe
public class SequencedItemList<T extends Element> {
    @GuardedBy(value="lock")
    private ListNode<T> head = null;
    @GuardedBy(value="lock")
    private ListNode<T> tail = null;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T item) {
        ListNode<T> node = new ListNode<T>(item);
        Object object = this.lock;
        synchronized (object) {
            if (this.tail == null) {
                this.head = node;
            } else {
                if (item.getSequenceNumber() <= ((Element)this.tail.item).getSequenceNumber()) {
                    return false;
                }
                this.tail.next = node;
            }
            this.tail = node;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int truncate(long upToSequenceNumber) {
        int count = 0;
        Object object = this.lock;
        synchronized (object) {
            while (this.head != null && ((Element)this.head.item).getSequenceNumber() <= upToSequenceNumber) {
                this.head = this.trim(this.head);
                ++count;
            }
            if (this.head == null) {
                this.tail = null;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            while (this.head != null) {
                this.head = this.trim(this.head);
            }
            this.tail = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getLast() {
        Object object = this.lock;
        synchronized (object) {
            return (T)(this.tail == null ? null : (Element)this.tail.item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<T> read(long afterSequenceNumber, int count) {
        ListNode<T> firstNode;
        Object object = this.lock;
        synchronized (object) {
            firstNode = this.head;
        }
        while (firstNode != null && ((Element)firstNode.item).getSequenceNumber() <= afterSequenceNumber) {
            object = this.lock;
            synchronized (object) {
                firstNode = firstNode.next;
            }
        }
        return new NodeIterator<T>(firstNode, count, this.lock);
    }

    private ListNode<T> trim(ListNode<T> node) {
        ListNode next = node.next;
        node.next = null;
        node.truncated = true;
        return next;
    }

    public static interface Element {
        public long getSequenceNumber();
    }

    private static class NodeIterator<T>
    implements Iterator<T> {
        private ListNode<T> currentNode;
        private final int maxCount;
        private int countSoFar;
        private final Object lock;

        NodeIterator(ListNode<T> firstNode, int maxCount, Object lock) {
            Preconditions.checkArgument(maxCount >= 0, "maxCount must be a positive integer");
            this.currentNode = firstNode;
            this.maxCount = maxCount;
            this.lock = lock;
        }

        @Override
        public boolean hasNext() {
            return this.countSoFar < this.maxCount && this.currentNode != null && !this.currentNode.truncated;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements left to iterate on.");
            }
            Object result = this.currentNode.item;
            this.fetchNext();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetchNext() {
            Object object = this.lock;
            synchronized (object) {
                if (this.hasNext()) {
                    this.currentNode = this.currentNode.next;
                    ++this.countSoFar;
                } else {
                    this.currentNode = null;
                }
            }
        }
    }

    private static class ListNode<T> {
        final T item;
        ListNode<T> next;
        boolean truncated;

        public String toString() {
            return this.item.toString();
        }

        @ConstructorProperties(value={"item"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ListNode(T item) {
            this.item = item;
        }
    }
}

