/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.InvalidPropertyValueException;
import io.pravega.common.util.MissingPropertyException;
import io.pravega.common.util.Property;
import java.util.Properties;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedProperties {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TypedProperties.class);
    private static final String SEPARATOR = ".";
    private final String keyPrefix;
    private final Properties properties;

    public TypedProperties(Properties properties, String namespace) {
        Preconditions.checkNotNull(properties, "properties");
        Exceptions.checkNotNullOrEmpty(namespace, "namespace");
        this.properties = properties;
        this.keyPrefix = namespace + SEPARATOR;
    }

    public String get(Property<String> property) throws ConfigurationException {
        return this.tryGet(property, s2 -> s2);
    }

    public int getInt(Property<Integer> property) throws ConfigurationException {
        return this.tryGet(property, Integer::parseInt);
    }

    public long getLong(Property<Long> property) throws ConfigurationException {
        return this.tryGet(property, Long::parseLong);
    }

    public double getDouble(Property<Double> property) throws ConfigurationException {
        return this.tryGet(property, Double::parseDouble);
    }

    public <T extends Enum<T>> T getEnum(Property<T> property, Class<T> enumClass) throws ConfigurationException {
        return (T)this.tryGet(property, s2 -> Enum.valueOf(enumClass, s2));
    }

    public boolean getBoolean(Property<Boolean> property) throws ConfigurationException {
        return this.tryGet(property, this::parseBoolean);
    }

    private <T> T tryGet(Property<T> property, Function<String, T> converter) {
        String propNewName = this.keyPrefix + property.getName();
        String propOldName = this.keyPrefix + property.getLegacyName();
        String propValue = null;
        if (property.hasLegacyName() && (propValue = this.properties.getProperty(propOldName, null)) != null) {
            log.warn("Deprecated property name '{}' used. Please use '{}' instead. Support for the old property name will be removed in a future version of Pravega.", (Object)propOldName, (Object)propNewName);
        }
        if (propValue == null) {
            propValue = this.properties.getProperty(propNewName, null);
        }
        if (propValue == null) {
            if (property.hasDefaultValue()) {
                return property.getDefaultValue();
            }
            throw new MissingPropertyException(String.format("Missing property with name [%s] (new name) / [%s] (old name}", propNewName, propOldName));
        }
        try {
            return converter.apply(propValue.trim());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidPropertyValueException(propNewName, propValue, ex);
        }
    }

    private boolean parseBoolean(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("0")) {
            return false;
        }
        throw new IllegalArgumentException(String.format("String '%s' cannot be interpreted as a valid Boolean.", value));
    }
}

