/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree;

import com.google.common.base.Preconditions;
import io.pravega.common.util.btree.PageWrapper;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class PageCollection {
    @GuardedBy(value="this")
    protected final HashMap<Long, PageWrapper> pageByOffset;
    @GuardedBy(value="this")
    protected long indexLength;

    PageCollection(long indexLength) {
        Preconditions.checkArgument(indexLength >= 0L, "indexLength must be a non-negative number.");
        this.indexLength = indexLength;
        this.pageByOffset = new HashMap();
    }

    synchronized long getIndexLength() {
        return this.indexLength;
    }

    synchronized int getCount() {
        return this.pageByOffset.size();
    }

    synchronized PageWrapper get(long offset) {
        return this.pageByOffset.getOrDefault(offset, null);
    }

    synchronized PageWrapper insert(PageWrapper page) {
        this.pageByOffset.put(page.getOffset(), page);
        return page;
    }

    synchronized void remove(PageWrapper page) {
        this.pageByOffset.remove(page.getOffset());
    }

    synchronized PageWrapper getRootPage() {
        return this.pageByOffset.values().stream().filter(page -> page.getParent() == null).findFirst().orElse(null);
    }
}

