/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.btree.BTreePage;
import io.pravega.common.util.btree.PagePointer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;

@ThreadSafe
class PageWrapper {
    private final AtomicReference<BTreePage> page;
    private final PageWrapper parent;
    private final PagePointer pointer;
    private final boolean newPage;
    private final AtomicLong offset;
    private final AtomicLong minOffset;
    private final AtomicBoolean needsFirstKeyUpdate;

    private PageWrapper(BTreePage page, PageWrapper parent, PagePointer pointer, boolean newPage) {
        this.page = new AtomicReference<BTreePage>(page);
        this.parent = parent;
        this.pointer = pointer;
        this.newPage = newPage;
        this.offset = new AtomicLong(this.pointer == null ? -1L : this.pointer.getOffset());
        this.minOffset = new AtomicLong(this.pointer == null ? -1L : this.pointer.getMinOffset());
        this.needsFirstKeyUpdate = new AtomicBoolean(false);
    }

    static PageWrapper wrapExisting(BTreePage page, PageWrapper parent, PagePointer pointer) {
        return new PageWrapper(page, parent, pointer, false);
    }

    static PageWrapper wrapNew(BTreePage page, PageWrapper parent, PagePointer pointer) {
        return new PageWrapper(page, parent, pointer, true);
    }

    BTreePage getPage() {
        return this.page.get();
    }

    boolean isModified() {
        return this.isNewPage() || this.getOffset() != (this.pointer == null ? -1L : this.pointer.getOffset());
    }

    boolean isIndexPage() {
        return this.getPage().getConfig().isIndexPage();
    }

    boolean needsFirstKeyUpdate() {
        return this.isIndexPage() && (this.needsFirstKeyUpdate.get() || this.isNewPage());
    }

    void markNeedsFirstKeyUpdate() {
        this.needsFirstKeyUpdate.set(true);
    }

    void setPage(BTreePage page) {
        this.page.set(page);
    }

    long getOffset() {
        return this.offset.get();
    }

    void setOffset(long value) {
        if (this.pointer != null && this.offset.get() != this.pointer.getOffset()) {
            throw new IllegalStateException("Cannot assign offset more than once.");
        }
        this.offset.set(value);
    }

    long getMinOffset() {
        return this.minOffset.get();
    }

    void setMinOffset(long value) {
        this.minOffset.set(value);
    }

    ByteArraySegment getPageKey() {
        ByteArraySegment r;
        ByteArraySegment byteArraySegment = r = this.pointer == null ? null : this.pointer.getKey();
        if (r == null && this.getPage().getCount() > 0) {
            r = this.getPage().getKeyAt(0);
        }
        return r;
    }

    public String toString() {
        return String.format("Offset = %s, Pointer = {%s}", this.offset, this.pointer);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PageWrapper getParent() {
        return this.parent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PagePointer getPointer() {
        return this.pointer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isNewPage() {
        return this.newPage;
    }
}

