/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree;

import com.google.common.base.Preconditions;
import io.pravega.common.util.btree.PageCollection;
import io.pravega.common.util.btree.PageWrapper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class UpdateablePageCollection
extends PageCollection {
    @GuardedBy(value="this")
    private long incompleteNewPageOffset = -1L;
    @GuardedBy(value="this")
    private final HashSet<Long> deletedPageOffsets = new HashSet();

    UpdateablePageCollection(long indexLength) {
        super(indexLength);
    }

    @Override
    synchronized PageWrapper insert(PageWrapper page) {
        Preconditions.checkArgument(this.incompleteNewPageOffset == -1L, "Cannot insert new page while a new page is incomplete.");
        if (page.isNewPage()) {
            this.incompleteNewPageOffset = page.getOffset();
        }
        return super.insert(page);
    }

    @Override
    synchronized void remove(PageWrapper page) {
        super.remove(page);
        if (this.incompleteNewPageOffset == page.getOffset()) {
            this.incompleteNewPageOffset = -1L;
        }
        this.deletedPageOffsets.add(page.getOffset());
        page.setOffset(-1L);
    }

    synchronized void complete(PageWrapper page) {
        Preconditions.checkArgument(this.pageByOffset.containsKey(page.getOffset()), "Given page is not registered.");
        Preconditions.checkArgument(this.incompleteNewPageOffset == -1L || this.incompleteNewPageOffset == page.getOffset(), "Not expecting this page to be completed.");
        this.incompleteNewPageOffset = -1L;
        long pageOffset = this.indexLength;
        this.indexLength += (long)page.getPage().getLength();
        this.pageByOffset.remove(page.getOffset());
        page.setOffset(pageOffset);
        this.pageByOffset.put(page.getOffset(), page);
    }

    synchronized void collectRemovedPageOffsets(Collection<Long> target) {
        target.addAll(this.deletedPageOffsets);
    }

    synchronized void collectLeafPages(Collection<PageWrapper> target) {
        this.pageByOffset.values().stream().filter(p -> !p.isIndexPage()).forEach(target::add);
    }

    synchronized void collectPages(Collection<Long> offsets, Collection<PageWrapper> target) {
        offsets.forEach(offset -> {
            PageWrapper p = this.pageByOffset.getOrDefault(offset, null);
            if (p != null) {
                target.add(p);
            }
        });
    }

    synchronized List<PageWrapper> getPagesSortedByOffset() {
        return this.pageByOffset.values().stream().sorted(Comparator.comparingLong(PageWrapper::getOffset)).collect(Collectors.toList());
    }
}

