/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree.sets;

import com.google.common.base.Preconditions;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.ByteArrayComparator;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.btree.SearchResult;
import io.pravega.common.util.btree.sets.BTreeSet;
import io.pravega.common.util.btree.sets.BTreeSetPage;
import io.pravega.common.util.btree.sets.PageCollection;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.NonNull;

class ItemIterator
implements AsyncIterator<List<ArrayView>> {
    private static final Comparator<ArrayView> COMPARATOR = BTreeSet.COMPARATOR;
    private final ArrayView firstItem;
    private final boolean firstItemInclusive;
    private final ArrayView lastItem;
    private final boolean lastItemInclusive;
    private final LocatePage locatePage;
    private final Duration fetchTimeout;
    private final AtomicBoolean finished;
    private final PageCollection pageCollection;
    private final AtomicReference<BTreeSetPage.LeafPage> lastPage;
    private final AtomicInteger processedPageCount;

    ItemIterator(@Nullable ArrayView firstItem, boolean firstItemInclusive, @Nullable ArrayView lastItem, boolean lastItemInclusive, @NonNull LocatePage locatePage, @NonNull Duration fetchTimeout) {
        if (locatePage == null) {
            throw new NullPointerException("locatePage is marked non-null but is null");
        }
        if (fetchTimeout == null) {
            throw new NullPointerException("fetchTimeout is marked non-null but is null");
        }
        if (firstItem == null) {
            this.firstItem = new ByteArraySegment(ByteArrayComparator.getMinValue());
            this.firstItemInclusive = true;
        } else {
            this.firstItem = firstItem;
            this.firstItemInclusive = firstItemInclusive;
        }
        this.lastItem = lastItem;
        this.lastItemInclusive = lastItemInclusive;
        this.validateArgs();
        this.locatePage = locatePage;
        this.fetchTimeout = fetchTimeout;
        this.pageCollection = new PageCollection();
        this.lastPage = new AtomicReference<Object>(null);
        this.finished = new AtomicBoolean();
        this.processedPageCount = new AtomicInteger();
    }

    private void validateArgs() {
        if (this.firstItem == null || this.lastItem == null) {
            return;
        }
        int c = COMPARATOR.compare(this.firstItem, this.lastItem);
        if (this.firstItemInclusive && this.lastItemInclusive) {
            Preconditions.checkArgument(c <= 0, "firstKey must be smaller than or equal to lastKey.");
        } else {
            Preconditions.checkArgument(c < 0, "firstKey must be smaller than lastKey.");
        }
    }

    @Override
    public CompletableFuture<List<ArrayView>> getNext() {
        if (this.finished.get()) {
            return CompletableFuture.completedFuture(null);
        }
        TimeoutTimer timer = new TimeoutTimer(this.fetchTimeout);
        return this.locateNextPage(timer).thenApply((T leafPage) -> {
            this.lastPage.set((BTreeSetPage.LeafPage)leafPage);
            List<ArrayView> result = null;
            if (leafPage != null) {
                result = this.extractFromPage((BTreeSetPage.LeafPage)leafPage);
                this.processedPageCount.incrementAndGet();
            }
            if (result == null) {
                this.finished.set(true);
            }
            return result;
        });
    }

    private CompletableFuture<BTreeSetPage.LeafPage> locateNextPage(TimeoutTimer timer) {
        if (this.lastPage.get() == null) {
            return this.locatePage.apply(this.firstItem, this.pageCollection, timer);
        }
        return this.getNextLeafPage(timer);
    }

    private CompletableFuture<BTreeSetPage.LeafPage> getNextLeafPage(TimeoutTimer timer) {
        BTreeSetPage.IndexPage parentPage;
        int pageKeyPos;
        BTreeSetPage lastPage = this.lastPage.get();
        assert (lastPage != null);
        do {
            if ((parentPage = (BTreeSetPage.IndexPage)this.pageCollection.get(lastPage.getPagePointer().getParentPageId())) == null) {
                return CompletableFuture.completedFuture(null);
            }
            ArrayView pageKey = lastPage.getPagePointer().getKey();
            SearchResult parentPos = parentPage.search(pageKey, 0);
            assert (parentPos.isExactMatch()) : "expecting exact match";
            pageKeyPos = parentPos.getPosition() + 1;
            this.pageCollection.remove(lastPage);
        } while (pageKeyPos == (lastPage = parentPage).getItemCount());
        ArrayView referenceKey = lastPage.getItemAt(pageKeyPos);
        return this.locatePage.apply(referenceKey, this.pageCollection, timer);
    }

    private List<ArrayView> extractFromPage(BTreeSetPage.LeafPage page) {
        int lastIndex;
        int firstIndex;
        if (this.processedPageCount.get() == 0) {
            SearchResult startPos = page.search(this.firstItem, 0);
            firstIndex = startPos.getPosition();
            if (startPos.isExactMatch() && !this.firstItemInclusive) {
                ++firstIndex;
            }
        } else {
            firstIndex = 0;
        }
        if (this.lastItem == null) {
            lastIndex = page.getItemCount() - 1;
        } else {
            SearchResult endPos = page.search(this.lastItem, 0);
            lastIndex = endPos.getPosition();
            if (!endPos.isExactMatch() || endPos.isExactMatch() && !this.lastItemInclusive) {
                --lastIndex;
            }
        }
        if (firstIndex > lastIndex) {
            return Collections.emptyList();
        }
        if (lastIndex < 0) {
            return null;
        }
        return page.getItems(firstIndex, lastIndex);
    }

    @FunctionalInterface
    static interface LocatePage {
        public CompletableFuture<BTreeSetPage.LeafPage> apply(ArrayView var1, PageCollection var2, TimeoutTimer var3);
    }
}

