/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree.sets;

import io.pravega.common.util.btree.sets.BTreeSetPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class PageCollection {
    private final HashMap<Long, BTreeSetPage> pages = new HashMap();
    private final HashMap<Long, Long> deletedPageIds = new HashMap();

    PageCollection() {
    }

    synchronized BTreeSetPage get(long pageId) {
        return this.pages.getOrDefault(pageId, null);
    }

    synchronized void pageLoaded(BTreeSetPage page) {
        this.pages.put(page.getPagePointer().getPageId(), page);
    }

    synchronized void pageUpdated(BTreeSetPage page) {
        assert (!this.deletedPageIds.containsKey(page.getPagePointer().getPageId()));
        this.pages.put(page.getPagePointer().getPageId(), page);
    }

    synchronized void pageDeleted(BTreeSetPage page) {
        this.deletedPageIds.put(page.getPagePointer().getPageId(), page.getPagePointer().getParentPageId());
        this.pages.remove(page.getPagePointer().getPageId());
    }

    synchronized void remove(BTreeSetPage page) {
        this.deletedPageIds.remove(page.getPagePointer().getPageId());
        this.pages.remove(page.getPagePointer().getPageId());
    }

    synchronized Collection<BTreeSetPage> getLeafPages() {
        return this.pages.values().stream().filter(p -> !p.isIndexPage()).collect(Collectors.toList());
    }

    synchronized Collection<BTreeSetPage> getIndexPages() {
        return this.pages.values().stream().filter(BTreeSetPage::isIndexPage).collect(Collectors.toList());
    }

    synchronized Collection<BTreeSetPage> getDeletedPagesParents() {
        return this.deletedPageIds.values().stream().map(this::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    synchronized Collection<Long> getDeletedPageIds() {
        return new ArrayList<Long>(this.deletedPageIds.keySet());
    }
}

