/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree.sets;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ArrayView;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import lombok.Generated;

class PagePointer {
    static final long ROOT_PAGE_ID = -1L;
    private static final long NO_PAGE_ID = Long.MIN_VALUE;
    private final ArrayView key;
    private final long pageId;
    private final long parentPageId;

    static PagePointer root() {
        return new PagePointer(null, -1L, Long.MIN_VALUE);
    }

    boolean hasParent() {
        return this.parentPageId != Long.MIN_VALUE;
    }

    static Comparator<PagePointer> getComparator(Comparator<ArrayView> keyComparator) {
        return (p1, p2) -> keyComparator.compare(p1.getKey(), p2.getKey());
    }

    public String toString() {
        return String.format("PageId=%s, ParentId=%s", this.pageId, this.parentPageId);
    }

    @ConstructorProperties(value={"key", "pageId", "parentPageId"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PagePointer(ArrayView key, long pageId, long parentPageId) {
        this.key = key;
        this.pageId = pageId;
        this.parentPageId = parentPageId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ArrayView getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getPageId() {
        return this.pageId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getParentPageId() {
        return this.parentPageId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagePointer)) {
            return false;
        }
        PagePointer other = (PagePointer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ArrayView this$key = this.getKey();
        ArrayView other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        if (this.getPageId() != other.getPageId()) {
            return false;
        }
        return this.getParentPageId() == other.getParentPageId();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagePointer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ArrayView $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        long $pageId = this.getPageId();
        result = result * 59 + (int)($pageId >>> 32 ^ $pageId);
        long $parentPageId = this.getParentPageId();
        result = result * 59 + (int)($parentPageId >>> 32 ^ $parentPageId);
        return result;
    }
}

