/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree.sets;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.btree.sets.BTreeSetPage;
import io.pravega.common.util.btree.sets.PageCollection;
import io.pravega.common.util.btree.sets.PagePointer;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;

@NotThreadSafe
class TreeModificationContext {
    private final PageCollection pageCollection;
    private final Map<Long, BTreeSetPage> modifiedParents = new HashMap<Long, BTreeSetPage>();
    private final Map<Long, List<PagePointer>> deletedByParent = new HashMap<Long, List<PagePointer>>();
    private final Map<Long, List<PagePointer>> createdByParent = new HashMap<Long, List<PagePointer>>();

    void deleted(PagePointer pagePointer) {
        this.deletedByParent.computeIfAbsent(pagePointer.getParentPageId(), i -> new ArrayList()).add(pagePointer);
    }

    void created(PagePointer pagePointer) {
        this.createdByParent.computeIfAbsent(pagePointer.getParentPageId(), i -> new ArrayList()).add(pagePointer);
    }

    private void forEachPage(Map<Long, List<PagePointer>> pages, BiConsumer<BTreeSetPage.IndexPage, List<PagePointer>> c, Comparator<PagePointer> pointerComparator) {
        pages.forEach((parentId, pointers) -> {
            BTreeSetPage.IndexPage parent = (BTreeSetPage.IndexPage)this.pageCollection.get((long)parentId);
            pointers.sort(pointerComparator);
            c.accept(parent, (List<PagePointer>)pointers);
            this.modifiedParents.put((Long)parentId, parent);
        });
    }

    void accept(BiConsumer<BTreeSetPage.IndexPage, List<PagePointer>> createdCallback, BiConsumer<BTreeSetPage.IndexPage, List<PagePointer>> deletedCallback, Comparator<PagePointer> pointerComparator) {
        this.forEachPage(this.deletedByParent, deletedCallback, pointerComparator);
        this.forEachPage(this.createdByParent, createdCallback, pointerComparator);
    }

    Collection<BTreeSetPage> getModifiedParents() {
        return this.modifiedParents.values();
    }

    @ConstructorProperties(value={"pageCollection"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TreeModificationContext(PageCollection pageCollection) {
        this.pageCollection = pageCollection;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PageCollection getPageCollection() {
        return this.pageCollection;
    }
}

