/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util.btree.sets;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.btree.sets.BTreeSet;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;

class UpdateItem
implements Comparable<UpdateItem> {
    @NonNull
    private final ArrayView item;
    private final boolean removal;

    @Override
    public int compareTo(UpdateItem other) {
        return BTreeSet.COMPARATOR.compare(this.item, other.item);
    }

    @ConstructorProperties(value={"item", "removal"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UpdateItem(@NonNull ArrayView item, boolean removal) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        this.item = item;
        this.removal = removal;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ArrayView getItem() {
        return this.item;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isRemoval() {
        return this.removal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateItem)) {
            return false;
        }
        UpdateItem other = (UpdateItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ArrayView this$item = this.getItem();
        ArrayView other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        return this.isRemoval() == other.isRemoval();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpdateItem;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ArrayView $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        result = result * 59 + (this.isRemoval() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "UpdateItem(item=" + this.getItem() + ", removal=" + this.isRemoval() + ")";
    }
}

