/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.client;

import io.pravega.client.stream.impl.Credentials;
import io.pravega.keycloak.client.KeycloakAuthzClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PravegaKeycloakCredentials
implements Credentials {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PravegaKeycloakCredentials.class);
    private transient KeycloakAuthzClient kc = null;
    private final String keycloakJsonString;

    public PravegaKeycloakCredentials() {
        this.init();
        this.keycloakJsonString = null;
        LOG.info("Loaded Keycloak Credentials");
    }

    public PravegaKeycloakCredentials(String keycloakJsonString) {
        this.keycloakJsonString = keycloakJsonString;
        this.init();
        LOG.info("Loaded Keycloak Credentials");
    }

    @Override
    public String getAuthenticationType() {
        return "Bearer";
    }

    @Override
    public String getAuthenticationToken() {
        this.init();
        return this.kc.getRPT();
    }

    private void init() {
        if (this.kc == null) {
            this.kc = this.keycloakJsonString != null ? KeycloakAuthzClient.builder().withConfigString(this.keycloakJsonString).build() : KeycloakAuthzClient.builder().build();
        }
    }
}

