/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.cert.crmf;

import io.pravega.keycloak.org.bouncycastle.asn1.cms.EnvelopedData;
import io.pravega.keycloak.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import io.pravega.keycloak.org.bouncycastle.asn1.crmf.EncKeyWithID;
import io.pravega.keycloak.org.bouncycastle.asn1.crmf.EncryptedKey;
import io.pravega.keycloak.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import io.pravega.keycloak.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.pravega.keycloak.org.bouncycastle.asn1.x509.GeneralName;
import io.pravega.keycloak.org.bouncycastle.cert.crmf.PKIArchiveControl;
import io.pravega.keycloak.org.bouncycastle.cms.CMSEnvelopedData;
import io.pravega.keycloak.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import io.pravega.keycloak.org.bouncycastle.cms.CMSException;
import io.pravega.keycloak.org.bouncycastle.cms.CMSProcessableByteArray;
import io.pravega.keycloak.org.bouncycastle.cms.RecipientInfoGenerator;
import io.pravega.keycloak.org.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.envGen.addRecipientInfoGenerator(recipientInfoGenerator);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor outputEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.envGen.generate(this.keyContent, outputEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

