/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.cms.bc;

import io.pravega.keycloak.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.pravega.keycloak.org.bouncycastle.cms.CMSException;
import io.pravega.keycloak.org.bouncycastle.cms.KEKRecipient;
import io.pravega.keycloak.org.bouncycastle.cms.bc.CMSUtils;
import io.pravega.keycloak.org.bouncycastle.crypto.CipherParameters;
import io.pravega.keycloak.org.bouncycastle.operator.OperatorException;
import io.pravega.keycloak.org.bouncycastle.operator.SymmetricKeyUnwrapper;
import io.pravega.keycloak.org.bouncycastle.operator.bc.BcSymmetricKeyUnwrapper;

public abstract class BcKEKRecipient
implements KEKRecipient {
    private SymmetricKeyUnwrapper unwrapper;

    public BcKEKRecipient(BcSymmetricKeyUnwrapper bcSymmetricKeyUnwrapper) {
        this.unwrapper = bcSymmetricKeyUnwrapper;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        try {
            return CMSUtils.getBcKey(this.unwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

