/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.cms.jcajce;

import io.pravega.keycloak.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.pravega.keycloak.org.bouncycastle.cms.jcajce.CMSUtils;
import io.pravega.keycloak.org.bouncycastle.cms.jcajce.JcaJceExtHelper;
import io.pravega.keycloak.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import io.pravega.keycloak.org.bouncycastle.operator.SymmetricKeyUnwrapper;
import io.pravega.keycloak.org.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;
import io.pravega.keycloak.org.bouncycastle.operator.jcajce.JceKTSKeyUnwrapper;
import io.pravega.keycloak.org.bouncycastle.operator.jcajce.JceSymmetricKeyUnwrapper;
import java.security.PrivateKey;
import javax.crypto.SecretKey;

class NamedJcaJceExtHelper
extends NamedJcaJceHelper
implements JcaJceExtHelper {
    public NamedJcaJceExtHelper(String string) {
        super(string);
    }

    public JceAsymmetricKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey) {
        privateKey = CMSUtils.cleanPrivateKey(privateKey);
        return new JceAsymmetricKeyUnwrapper(algorithmIdentifier, privateKey).setProvider(this.providerName);
    }

    public JceKTSKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey, byte[] byArray, byte[] byArray2) {
        privateKey = CMSUtils.cleanPrivateKey(privateKey);
        return new JceKTSKeyUnwrapper(algorithmIdentifier, privateKey, byArray, byArray2).setProvider(this.providerName);
    }

    public SymmetricKeyUnwrapper createSymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, SecretKey secretKey) {
        return new JceSymmetricKeyUnwrapper(algorithmIdentifier, secretKey).setProvider(this.providerName);
    }
}

