/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.crypto.agreement;

import io.pravega.keycloak.org.bouncycastle.crypto.CipherParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.agreement.DHBasicAgreement;
import io.pravega.keycloak.org.bouncycastle.crypto.params.DHUPrivateParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.params.DHUPublicParameters;
import io.pravega.keycloak.org.bouncycastle.util.Arrays;
import io.pravega.keycloak.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DHUnifiedAgreement {
    private DHUPrivateParameters privParams;

    public void init(CipherParameters cipherParameters) {
        this.privParams = (DHUPrivateParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters cipherParameters) {
        DHUPublicParameters dHUPublicParameters = (DHUPublicParameters)cipherParameters;
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        DHBasicAgreement dHBasicAgreement2 = new DHBasicAgreement();
        dHBasicAgreement.init(this.privParams.getStaticPrivateKey());
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(dHUPublicParameters.getStaticPublicKey());
        dHBasicAgreement2.init(this.privParams.getEphemeralPrivateKey());
        BigInteger bigInteger2 = dHBasicAgreement2.calculateAgreement(dHUPublicParameters.getEphemeralPublicKey());
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger2), BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger));
    }
}

