/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.crypto.generators;

import io.pravega.keycloak.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.pravega.keycloak.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import io.pravega.keycloak.org.bouncycastle.crypto.KeyGenerationParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import io.pravega.keycloak.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.params.DHParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

