/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.crypto.tls;

import io.pravega.keycloak.org.bouncycastle.crypto.BasicAgreement;
import io.pravega.keycloak.org.bouncycastle.crypto.agreement.DHBasicAgreement;
import io.pravega.keycloak.org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import io.pravega.keycloak.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.pravega.keycloak.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.AbstractTlsAgreementCredentials;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.Certificate;
import io.pravega.keycloak.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DefaultTlsAgreementCredentials
extends AbstractTlsAgreementCredentials {
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;
    protected BasicAgreement basicAgreement;
    protected boolean truncateAgreement;

    public DefaultTlsAgreementCredentials(Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (asymmetricKeyParameter instanceof DHPrivateKeyParameters) {
            this.basicAgreement = new DHBasicAgreement();
            this.truncateAgreement = true;
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            this.basicAgreement = new ECDHBasicAgreement();
            this.truncateAgreement = false;
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.certificate = certificate;
        this.privateKey = asymmetricKeyParameter;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] generateAgreement(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.basicAgreement.init(this.privateKey);
        BigInteger bigInteger = this.basicAgreement.calculateAgreement(asymmetricKeyParameter);
        if (this.truncateAgreement) {
            return BigIntegers.asUnsignedByteArray(bigInteger);
        }
        return BigIntegers.asUnsignedByteArray(this.basicAgreement.getFieldSize(), bigInteger);
    }
}

