/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.dvcs;

import io.pravega.keycloak.org.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import io.pravega.keycloak.org.bouncycastle.asn1.dvcs.DVCSTime;
import io.pravega.keycloak.org.bouncycastle.asn1.dvcs.Data;
import io.pravega.keycloak.org.bouncycastle.asn1.dvcs.ServiceType;
import io.pravega.keycloak.org.bouncycastle.cms.CMSSignedData;
import io.pravega.keycloak.org.bouncycastle.dvcs.DVCSException;
import io.pravega.keycloak.org.bouncycastle.dvcs.DVCSRequest;
import io.pravega.keycloak.org.bouncycastle.dvcs.DVCSRequestBuilder;
import java.io.IOException;
import java.util.Date;

public class VSDRequestBuilder
extends DVCSRequestBuilder {
    public VSDRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VSD));
    }

    public void setRequestTime(Date date) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(date));
    }

    public DVCSRequest build(CMSSignedData cMSSignedData) throws DVCSException {
        try {
            Data data = new Data(cMSSignedData.getEncoded());
            return this.createDVCRequest(data);
        }
        catch (IOException iOException) {
            throw new DVCSException("Failed to encode CMS signed data", iOException);
        }
    }
}

