/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.pkcs.bc;

import io.pravega.keycloak.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import io.pravega.keycloak.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.pravega.keycloak.org.bouncycastle.crypto.CipherParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.ExtendedDigest;
import io.pravega.keycloak.org.bouncycastle.crypto.digests.SHA1Digest;
import io.pravega.keycloak.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import io.pravega.keycloak.org.bouncycastle.crypto.io.CipherInputStream;
import io.pravega.keycloak.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import io.pravega.keycloak.org.bouncycastle.operator.GenericKey;
import io.pravega.keycloak.org.bouncycastle.operator.InputDecryptor;
import io.pravega.keycloak.org.bouncycastle.operator.InputDecryptorProvider;
import io.pravega.keycloak.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;
import java.io.InputStream;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest extendedDigest) {
        this.digest = extendedDigest;
    }

    public InputDecryptorProvider build(final char[] cArray) {
        return new InputDecryptorProvider(){

            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher paddedBufferedBlockCipher = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters cipherParameters = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, paddedBufferedBlockCipher.getBlockSize(), pKCS12PBEParams, cArray);
                paddedBufferedBlockCipher.init(false, cipherParameters);
                return new InputDecryptor(){

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    public InputStream getInputStream(InputStream inputStream) {
                        return new CipherInputStream(inputStream, paddedBufferedBlockCipher);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
                    }
                };
            }
        };
    }
}

