/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.pqc.jcajce.provider.newhope;

import io.pravega.keycloak.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.pravega.keycloak.org.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import io.pravega.keycloak.org.bouncycastle.pqc.crypto.ExchangePair;
import io.pravega.keycloak.org.bouncycastle.pqc.crypto.newhope.NHAgreement;
import io.pravega.keycloak.org.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import io.pravega.keycloak.org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import io.pravega.keycloak.org.bouncycastle.pqc.jcajce.provider.newhope.BCNHPrivateKey;
import io.pravega.keycloak.org.bouncycastle.pqc.jcajce.provider.newhope.BCNHPublicKey;
import io.pravega.keycloak.org.bouncycastle.util.Arrays;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ShortBufferException;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private NHAgreement agreement;
    private BCNHPublicKey otherPartyKey;
    private NHExchangePairGenerator exchangePairGenerator;
    private byte[] shared;

    public KeyAgreementSpi() {
        super("NH", null);
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key != null) {
            this.agreement = new NHAgreement();
            this.agreement.init(((BCNHPrivateKey)key).getKeyParams());
        } else {
            this.exchangePairGenerator = new NHExchangePairGenerator(secureRandom);
        }
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("NewHope does not require parameters");
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!bl) {
            throw new IllegalStateException("NewHope can only be between two parties.");
        }
        this.otherPartyKey = (BCNHPublicKey)key;
        if (this.exchangePairGenerator != null) {
            ExchangePair exchangePair = this.exchangePairGenerator.generateExchange((AsymmetricKeyParameter)this.otherPartyKey.getKeyParams());
            this.shared = exchangePair.getSharedValue();
            return new BCNHPublicKey((NHPublicKeyParameters)exchangePair.getPublicKey());
        }
        this.shared = this.agreement.calculateAgreement(this.otherPartyKey.getKeyParams());
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] byArray = Arrays.clone(this.shared);
        Arrays.fill(this.shared, (byte)0);
        return byArray;
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        System.arraycopy(this.shared, 0, byArray, n, this.shared.length);
        Arrays.fill(this.shared, (byte)0);
        return this.shared.length;
    }

    protected byte[] calcSecret() {
        return this.engineGenerateSecret();
    }
}

