/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.pqc.jcajce.provider.xmss;

import io.pravega.keycloak.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.pravega.keycloak.org.bouncycastle.asn1.ASN1Set;
import io.pravega.keycloak.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.pravega.keycloak.org.bouncycastle.crypto.CipherParameters;
import io.pravega.keycloak.org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import io.pravega.keycloak.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import io.pravega.keycloak.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import io.pravega.keycloak.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import io.pravega.keycloak.org.bouncycastle.pqc.jcajce.interfaces.XMSSMTPrivateKey;
import io.pravega.keycloak.org.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import io.pravega.keycloak.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCXMSSMTPrivateKey
implements PrivateKey,
XMSSMTPrivateKey {
    private static final long serialVersionUID = 7682140473044521395L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient XMSSMTPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCXMSSMTPrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.keyParams = xMSSMTPrivateKeyParameters;
    }

    public BCXMSSMTPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        XMSSMTKeyParams xMSSMTKeyParams = XMSSMTKeyParams.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        this.treeDigest = xMSSMTKeyParams.getTreeDigest().getAlgorithm();
        this.keyParams = (XMSSMTPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public long getUsagesRemaining() {
        return this.keyParams.getUsagesRemaining();
    }

    public String getAlgorithm() {
        return "XMSSMT";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSMTPrivateKey) {
            BCXMSSMTPrivateKey bCXMSSMTPrivateKey = (BCXMSSMTPrivateKey)object;
            return this.treeDigest.equals(bCXMSSMTPrivateKey.treeDigest) && Arrays.areEqual(this.keyParams.toByteArray(), bCXMSSMTPrivateKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.keyParams.toByteArray());
    }

    ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigest;
    }

    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    public int getLayers() {
        return this.keyParams.getParameters().getLayers();
    }

    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName(this.treeDigest);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

