/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.authorization.client;

import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonIgnore;
import io.pravega.keycloak.org.apache.http.client.HttpClient;
import io.pravega.keycloak.org.apache.http.impl.client.HttpClients;
import io.pravega.keycloak.org.keycloak.authorization.client.ClientAuthenticator;
import io.pravega.keycloak.org.keycloak.representations.adapters.config.AdapterConfig;
import io.pravega.keycloak.org.keycloak.util.BasicAuthHelper;
import java.util.List;
import java.util.Map;

public class Configuration
extends AdapterConfig {
    @JsonIgnore
    private HttpClient httpClient;
    @JsonIgnore
    private ClientAuthenticator clientAuthenticator = this.createDefaultClientAuthenticator();

    public Configuration() {
    }

    public Configuration(String authServerUrl, String realm, String clientId, Map<String, Object> clientCredentials, HttpClient httpClient) {
        this.authServerUrl = authServerUrl;
        this.setAuthServerUrl(authServerUrl);
        this.setRealm(realm);
        this.setResource(clientId);
        this.setCredentials(clientCredentials);
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClients.createDefault();
        }
        return this.httpClient;
    }

    ClientAuthenticator getClientAuthenticator() {
        return this.clientAuthenticator;
    }

    private ClientAuthenticator createDefaultClientAuthenticator() {
        return new ClientAuthenticator(){

            @Override
            public void configureClientCredentials(Map<String, List<String>> requestParams, Map<String, String> requestHeaders) {
                String secret = (String)Configuration.this.getCredentials().get("secret");
                if (secret == null) {
                    throw new RuntimeException("Client secret not provided.");
                }
                requestHeaders.put("Authorization", BasicAuthHelper.createHeader(Configuration.this.getResource(), secret));
            }
        };
    }
}

