/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.common.util;

import io.pravega.keycloak.org.keycloak.common.util.BouncyIntegration;
import io.pravega.keycloak.org.keycloak.common.util.FindFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;

public class KeystoreUtil {
    public static KeyStore loadKeyStore(String filename, String password) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream trustStream = null;
        if (filename.startsWith("classpath:")) {
            String resourcePath = filename.replace("classpath:", "");
            if (Thread.currentThread().getContextClassLoader() != null) {
                trustStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
            }
            if (trustStream == null) {
                trustStream = KeystoreUtil.class.getResourceAsStream(resourcePath);
            }
            if (trustStream == null) {
                throw new RuntimeException("Unable to find key store in classpath");
            }
        } else {
            trustStream = new FileInputStream(new File(filename));
        }
        trustStore.load(trustStream, password.toCharArray());
        trustStream.close();
        return trustStore;
    }

    public static KeyPair loadKeyPairFromKeystore(String keystoreFile, String storePassword, String keyPassword, String keyAlias, KeystoreFormat format) {
        InputStream stream = FindFile.findFile(keystoreFile);
        try {
            KeyStore keyStore = null;
            keyStore = format == KeystoreFormat.JKS ? KeyStore.getInstance(format.toString()) : KeyStore.getInstance(format.toString(), "BC");
            keyStore.load(stream, storePassword.toCharArray());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword.toCharArray());
            if (privateKey == null) {
                throw new RuntimeException("Couldn't load key with alias '" + keyAlias + "' from keystore");
            }
            PublicKey publicKey = keyStore.getCertificate(keyAlias).getPublicKey();
            return new KeyPair(publicKey, privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load private key: " + e.getMessage(), e);
        }
    }

    static {
        BouncyIntegration.init();
    }

    public static enum KeystoreFormat {
        JKS,
        PKCS12;

    }
}

