/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultivaluedHashMap<K, V>
extends HashMap<K, List<V>> {
    public MultivaluedHashMap() {
    }

    public MultivaluedHashMap(Map<K, List<V>> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map can not be null");
        }
        this.putAll(map);
    }

    public MultivaluedHashMap(MultivaluedHashMap<K, V> config) {
        this.addAll(config);
    }

    public void putSingle(K key, V value) {
        ArrayList<V> list = new ArrayList<V>();
        list.add(value);
        this.put(key, list);
    }

    public void addAll(K key, V ... newValues) {
        for (V value : newValues) {
            this.add(key, value);
        }
    }

    public void addAll(K key, List<V> valueList) {
        for (V value : valueList) {
            this.add(key, value);
        }
    }

    public void addFirst(K key, V value) {
        List list = (List)this.get(key);
        if (list == null) {
            this.add(key, value);
        } else {
            list.add(0, value);
        }
    }

    public final void add(K key, V value) {
        this.getList(key).add(value);
    }

    public final void addMultiple(K key, Collection<V> values) {
        this.getList(key).addAll(values);
    }

    public V getFirst(K key) {
        List list = (List)this.get(key);
        return list == null ? null : (V)list.get(0);
    }

    public final List<V> getList(K key) {
        ArrayList list = (ArrayList)this.get(key);
        if (list == null) {
            list = new ArrayList();
            this.put(key, list);
        }
        return list;
    }

    public final void addAll(MultivaluedHashMap<K, V> other) {
        for (Map.Entry entry : other.entrySet()) {
            this.getList(entry.getKey()).addAll((Collection)entry.getValue());
        }
    }

    public boolean equalsIgnoreValueOrder(MultivaluedHashMap<K, V> omap) {
        if (this == omap) {
            return true;
        }
        if (!this.keySet().equals(omap.keySet())) {
            return false;
        }
        for (Map.Entry e : this.entrySet()) {
            List list = (List)e.getValue();
            List olist = (List)omap.get(e.getKey());
            if (list.size() == olist.size() && list.containsAll(olist) && olist.containsAll(list)) continue;
            return false;
        }
        return true;
    }
}

