/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.common.util;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringSerialization {
    private static final Map<Class<?>, DeSerializerFunction> WELL_KNOWN_DESERIALIZERS = new LinkedHashMap();
    private static final String SEPARATOR = ";";
    private static final Pattern ESCAPE_PATTERN = Pattern.compile(";");
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile(";;");
    private static final Pattern VALUE_PATTERN = Pattern.compile("([NV])((?:[^;]|;;)*?)($|;(?!;))", 32);

    public static String serialize(Object ... toSerialize) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toSerialize.length; ++i) {
            Object o = toSerialize[i];
            String stringO = StringSerialization.getStringFrom(o);
            String escapedStringO = ESCAPE_PATTERN.matcher(stringO).replaceAll(";;");
            sb.append(escapedStringO);
            if (i >= toSerialize.length - 1) continue;
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    public static Deserializer deserialize(String what) {
        return new Deserializer(what);
    }

    private static String getStringFrom(Object o) {
        if (o == null) {
            return "N";
        }
        Class<?> c = o.getClass();
        DeSerializerFunction f = WELL_KNOWN_DESERIALIZERS.get(c);
        return "V" + (f == null ? o : f.serialize(o));
    }

    private static <T> T getObjectFrom(String escapedString, Class<T> clazz) {
        DeSerializerFunction f = WELL_KNOWN_DESERIALIZERS.get(clazz);
        String res = f == null ? escapedString : f.deserialize(escapedString);
        return clazz.cast(res);
    }

    static {
        WELL_KNOWN_DESERIALIZERS.put(URI.class, DeSerializerFunction.URI);
        WELL_KNOWN_DESERIALIZERS.put(String.class, DeSerializerFunction.OBJECT);
    }

    public static class Deserializer {
        private final Matcher valueMatcher;

        public Deserializer(String what) {
            this.valueMatcher = VALUE_PATTERN.matcher(what);
        }

        public <T> T next(Class<T> clazz) {
            if (!this.valueMatcher.find()) {
                return null;
            }
            String valueOrNull = this.valueMatcher.group(1);
            if (valueOrNull == null || Objects.equals(valueOrNull, "N")) {
                return null;
            }
            String escapedStringO = this.valueMatcher.group(2);
            String unescapedStringO = UNESCAPE_PATTERN.matcher(escapedStringO).replaceAll(StringSerialization.SEPARATOR);
            return (T)StringSerialization.getObjectFrom(unescapedStringO, clazz);
        }
    }

    private static enum DeSerializerFunction {
        OBJECT{

            @Override
            public String serialize(Object o) {
                return o.toString();
            }

            @Override
            public Object deserialize(String s2) {
                return s2;
            }
        }
        ,
        URI{

            @Override
            public String serialize(Object o) {
                return o.toString();
            }

            @Override
            public Object deserialize(String s2) {
                return java.net.URI.create(s2);
            }
        };


        public abstract String serialize(Object var1);

        public abstract Object deserialize(String var1);
    }
}

