/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.jose.jwe;

import io.pravega.keycloak.org.keycloak.jose.jwe.JWEUtils;
import io.pravega.keycloak.org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;

public class JWEKeyStorage {
    private Key encryptionKey;
    private Key decryptionKey;
    private byte[] cekBytes;
    private Map<KeyUse, Key> decodedCEK = new HashMap<KeyUse, Key>();
    private JWEEncryptionProvider encryptionProvider;

    public Key getEncryptionKey() {
        return this.encryptionKey;
    }

    public JWEKeyStorage setEncryptionKey(Key encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public Key getDecryptionKey() {
        return this.decryptionKey;
    }

    public JWEKeyStorage setDecryptionKey(Key decryptionKey) {
        this.decryptionKey = decryptionKey;
        return this;
    }

    public void setCEKBytes(byte[] cekBytes) {
        this.cekBytes = cekBytes;
    }

    public byte[] getCekBytes() {
        if (this.cekBytes == null) {
            this.cekBytes = this.encryptionProvider.serializeCEK(this);
        }
        return this.cekBytes;
    }

    public JWEKeyStorage setCEKKey(Key key, KeyUse keyUse) {
        this.decodedCEK.put(keyUse, key);
        return this;
    }

    public Key getCEKKey(KeyUse keyUse, boolean generateIfNotPresent) {
        Key key = this.decodedCEK.get((Object)keyUse);
        if (key == null) {
            if (this.encryptionProvider != null) {
                if (this.cekBytes == null && generateIfNotPresent) {
                    this.generateCekBytes();
                }
                if (this.cekBytes != null) {
                    this.encryptionProvider.deserializeCEK(this);
                }
            } else {
                throw new IllegalStateException("encryptionProvider needs to be set");
            }
        }
        return this.decodedCEK.get((Object)keyUse);
    }

    private void generateCekBytes() {
        int cekLength = this.encryptionProvider.getExpectedCEKLength();
        this.cekBytes = JWEUtils.generateSecret(cekLength);
    }

    public void setEncryptionProvider(JWEEncryptionProvider encryptionProvider) {
        this.encryptionProvider = encryptionProvider;
    }

    public static enum KeyUse {
        ENCRYPTION,
        SIGNATURE;

    }
}

