/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.jose.jwe.alg;

import io.pravega.keycloak.org.bouncycastle.crypto.engines.AESWrapEngine;
import io.pravega.keycloak.org.bouncycastle.crypto.params.KeyParameter;
import io.pravega.keycloak.org.keycloak.jose.jwe.JWEKeyStorage;
import io.pravega.keycloak.org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import io.pravega.keycloak.org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import java.security.Key;

public class AesKeyWrapAlgorithmProvider
implements JWEAlgorithmProvider {
    @Override
    public byte[] decodeCek(byte[] encodedCek, Key encryptionKey) throws Exception {
        AESWrapEngine encrypter = new AESWrapEngine();
        encrypter.init(false, new KeyParameter(encryptionKey.getEncoded()));
        return encrypter.unwrap(encodedCek, 0, encodedCek.length);
    }

    @Override
    public byte[] encodeCek(JWEEncryptionProvider encryptionProvider, JWEKeyStorage keyStorage, Key encryptionKey) throws Exception {
        AESWrapEngine encrypter = new AESWrapEngine();
        encrypter.init(true, new KeyParameter(encryptionKey.getEncoded()));
        byte[] cekBytes = keyStorage.getCekBytes();
        return encrypter.wrap(cekBytes, 0, cekBytes.length);
    }
}

