/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.representations.account;

import io.pravega.keycloak.org.keycloak.representations.account.SessionRepresentation;
import java.util.ArrayList;
import java.util.List;

public class DeviceRepresentation {
    public static final String UNKNOWN = "Unknown";
    private static final String OTHER = "Other";
    private static final String BROWSER_VERSION_SEPARATOR = "/";
    private String id;
    private String ipAddress;
    private String os;
    private String osVersion;
    private String browser;
    private String device;
    private int lastAccess;
    private Boolean current;
    private List<SessionRepresentation> sessions;
    private boolean mobile;

    public static DeviceRepresentation unknown() {
        DeviceRepresentation device = new DeviceRepresentation();
        device.setOs(OTHER);
        device.setDevice(OTHER);
        return device;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ip) {
        this.ipAddress = ip;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getOsVersion() {
        if (this.osVersion == null) {
            return UNKNOWN;
        }
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public void setBrowser(String browser, String version) {
        this.browser = browser == null ? OTHER : browser + BROWSER_VERSION_SEPARATOR + (version == null ? UNKNOWN : version);
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public int getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(int lastAccess) {
        this.lastAccess = lastAccess;
    }

    public Boolean getCurrent() {
        return this.current;
    }

    public void setCurrent(Boolean current) {
        this.current = current;
    }

    public void addSession(SessionRepresentation sessionRep) {
        if (this.sessions == null) {
            this.sessions = new ArrayList<SessionRepresentation>();
        }
        this.sessions.add(sessionRep);
    }

    public List<SessionRepresentation> getSessions() {
        return this.sessions;
    }

    public void setMobile(boolean mobile) {
        this.mobile = mobile;
    }

    public boolean isMobile() {
        return this.mobile;
    }
}

