/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.representations.idm.authorization;

import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonInclude;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.DecisionStrategy;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.Logic;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.ResourceRepresentation;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.ScopeRepresentation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AbstractPolicyRepresentation {
    private String id;
    private String name;
    private String description;
    private String type;
    private Set<String> policies;
    private Set<String> resources;
    private Set<String> scopes;
    private Logic logic = Logic.POSITIVE;
    private DecisionStrategy decisionStrategy = DecisionStrategy.UNANIMOUS;
    private String owner;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<ResourceRepresentation> resourcesData;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<ScopeRepresentation> scopesData;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.decisionStrategy;
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.decisionStrategy = decisionStrategy;
    }

    public Logic getLogic() {
        return this.logic;
    }

    public void setLogic(Logic logic) {
        this.logic = logic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<String> getPolicies() {
        return this.policies;
    }

    public void setPolicies(Set<String> policies) {
        this.policies = policies;
    }

    public void addPolicy(String ... id) {
        if (this.policies == null) {
            this.policies = new HashSet<String>();
        }
        this.policies.addAll(Arrays.asList(id));
    }

    public void removePolicy(String policy) {
        if (this.policies != null) {
            this.policies.remove(policy);
        }
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public void setResources(Set<String> resources) {
        this.resources = resources;
    }

    public void addResource(String id) {
        if (this.resources == null) {
            this.resources = new HashSet<String>();
        }
        this.resources.add(id);
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public void addScope(String ... id) {
        if (this.scopes == null) {
            this.scopes = new HashSet<String>();
        }
        this.scopes.addAll(Arrays.asList(id));
    }

    public void removeScope(String scope) {
        if (this.scopes != null) {
            this.scopes.remove(scope);
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPolicyRepresentation policy = (AbstractPolicyRepresentation)o;
        return Objects.equals(this.getId(), policy.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public <R> void setResourcesData(Set<ResourceRepresentation> resources) {
        this.resourcesData = resources;
    }

    public Set<ResourceRepresentation> getResourcesData() {
        return this.resourcesData;
    }

    public void setScopesData(Set<ScopeRepresentation> scopesData) {
        this.scopesData = scopesData;
    }

    public Set<ScopeRepresentation> getScopesData() {
        return this.scopesData;
    }
}

