/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.representations.idm.authorization;

import io.pravega.keycloak.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.pravega.keycloak.org.keycloak.TokenIdGenerator;
import io.pravega.keycloak.org.keycloak.json.StringListMapDeserializer;
import io.pravega.keycloak.org.keycloak.representations.AccessToken;
import io.pravega.keycloak.org.keycloak.representations.JsonWebToken;
import io.pravega.keycloak.org.keycloak.representations.idm.authorization.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PermissionTicketToken
extends JsonWebToken {
    private final List<Permission> permissions;
    @JsonDeserialize(using=StringListMapDeserializer.class)
    private Map<String, List<String>> claims;

    public PermissionTicketToken() {
        this(new ArrayList<Permission>());
    }

    public PermissionTicketToken(List<Permission> permissions, String audience, AccessToken accessToken) {
        if (accessToken != null) {
            this.id(TokenIdGenerator.generateId());
            this.subject(accessToken.getSubject());
            this.expiration(accessToken.getExpiration());
            this.notBefore(accessToken.getNotBefore());
            this.issuedAt(accessToken.getIssuedAt());
            this.issuedFor(accessToken.getIssuedFor());
        }
        if (audience != null) {
            this.audience(audience);
        }
        this.permissions = permissions;
    }

    public PermissionTicketToken(List<Permission> resources) {
        this(resources, null, null);
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public Map<String, List<String>> getClaims() {
        return this.claims;
    }

    public void setClaims(Map<String, List<String>> claims) {
        this.claims = claims;
    }
}

