/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.util;

import io.pravega.keycloak.org.keycloak.crypto.KeyUse;
import io.pravega.keycloak.org.keycloak.crypto.KeyWrapper;
import io.pravega.keycloak.org.keycloak.jose.jwk.JSONWebKeySet;
import io.pravega.keycloak.org.keycloak.jose.jwk.JWK;
import io.pravega.keycloak.org.keycloak.jose.jwk.JWKParser;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class JWKSUtils {
    public static Map<String, PublicKey> getKeysForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        HashMap<String, PublicKey> result = new HashMap<String, PublicKey>();
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (!jwk.getPublicKeyUse().equals(requestedUse.asString()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            result.put(jwk.getKeyId(), parser.toPublicKey());
        }
        return result;
    }

    public static Map<String, KeyWrapper> getKeyWrappersForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        HashMap<String, KeyWrapper> result = new HashMap<String, KeyWrapper>();
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (!jwk.getPublicKeyUse().equals(requestedUse.asString()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            KeyWrapper keyWrapper = new KeyWrapper();
            keyWrapper.setKid(jwk.getKeyId());
            if (jwk.getAlgorithm() != null) {
                keyWrapper.setAlgorithm(jwk.getAlgorithm());
            } else if (jwk.getKeyType().equalsIgnoreCase("RSA")) {
                keyWrapper.setAlgorithm("RS256");
            }
            keyWrapper.setType(jwk.getKeyType());
            keyWrapper.setUse(JWKSUtils.getKeyUse(jwk.getPublicKeyUse()));
            keyWrapper.setPublicKey(parser.toPublicKey());
            result.put(keyWrapper.getKid(), keyWrapper);
        }
        return result;
    }

    private static KeyUse getKeyUse(String keyUse) {
        switch (keyUse) {
            case "sig": {
                return KeyUse.SIG;
            }
            case "enc": {
                return KeyUse.ENC;
            }
        }
        return null;
    }

    public static JWK getKeyForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (!parser.getJwk().getPublicKeyUse().equals(requestedUse.asString()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            return jwk;
        }
        return null;
    }
}

