/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.pravega.auth.AuthenticationException;

public class AuthHelper {
    public static String getAuthorizationHeader(String method, String token) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(method));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(token));
        return String.format("%s %s", method, token);
    }

    public static String[] extractMethodAndToken(String credentials) throws AuthenticationException {
        Preconditions.checkNotNull(credentials, "Credentials cannot be null");
        String[] parts = credentials.split("\\s+", 2);
        if (parts.length != 2) {
            throw new AuthenticationException("Malformed request");
        }
        return parts;
    }
}

