/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import com.google.common.base.Preconditions;
import io.pravega.common.ObjectBuilder;
import io.pravega.schemaregistry.contract.data.VersionInfo;

public class BackwardAndForward {
    public static final BackwardPolicy BACKWARD = new Backward();
    public static final BackwardPolicy BACKWARD_TRANSITIVE = new BackwardTransitive();
    public static final ForwardPolicy FORWARD = new Forward();
    public static final ForwardPolicy FORWARD_TRANSITIVE = new ForwardTransitive();
    private final BackwardPolicy backwardPolicy;
    private final ForwardPolicy forwardPolicy;

    BackwardAndForward(BackwardPolicy backwardPolicy, ForwardPolicy forwardPolicy) {
        Preconditions.checkArgument(backwardPolicy != null || forwardPolicy != null);
        Preconditions.checkArgument(backwardPolicy == null || backwardPolicy instanceof Backward || backwardPolicy instanceof BackwardTill || backwardPolicy instanceof BackwardTransitive);
        Preconditions.checkArgument(forwardPolicy == null || forwardPolicy instanceof Forward || forwardPolicy instanceof ForwardTill || forwardPolicy instanceof ForwardTransitive);
        this.backwardPolicy = backwardPolicy;
        this.forwardPolicy = forwardPolicy;
    }

    public static BackwardAndForwardBuilder builder() {
        return new BackwardAndForwardBuilder();
    }

    public BackwardPolicy getBackwardPolicy() {
        return this.backwardPolicy;
    }

    public ForwardPolicy getForwardPolicy() {
        return this.forwardPolicy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BackwardAndForward)) {
            return false;
        }
        BackwardAndForward other = (BackwardAndForward)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BackwardPolicy this$backwardPolicy = this.getBackwardPolicy();
        BackwardPolicy other$backwardPolicy = other.getBackwardPolicy();
        if (this$backwardPolicy == null ? other$backwardPolicy != null : !this$backwardPolicy.equals(other$backwardPolicy)) {
            return false;
        }
        ForwardPolicy this$forwardPolicy = this.getForwardPolicy();
        ForwardPolicy other$forwardPolicy = other.getForwardPolicy();
        return !(this$forwardPolicy == null ? other$forwardPolicy != null : !this$forwardPolicy.equals(other$forwardPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BackwardAndForward;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BackwardPolicy $backwardPolicy = this.getBackwardPolicy();
        result = result * 59 + ($backwardPolicy == null ? 43 : $backwardPolicy.hashCode());
        ForwardPolicy $forwardPolicy = this.getForwardPolicy();
        result = result * 59 + ($forwardPolicy == null ? 43 : $forwardPolicy.hashCode());
        return result;
    }

    public String toString() {
        return "BackwardAndForward(backwardPolicy=" + this.getBackwardPolicy() + ", forwardPolicy=" + this.getForwardPolicy() + ")";
    }

    public static class BackwardAndForwardBuilder
    implements ObjectBuilder<BackwardAndForward> {
        private BackwardPolicy backwardPolicy;
        private ForwardPolicy forwardPolicy;

        BackwardAndForwardBuilder() {
        }

        public BackwardAndForwardBuilder backwardPolicy(BackwardPolicy backwardPolicy) {
            this.backwardPolicy = backwardPolicy;
            return this;
        }

        public BackwardAndForwardBuilder forwardPolicy(ForwardPolicy forwardPolicy) {
            this.forwardPolicy = forwardPolicy;
            return this;
        }

        @Override
        public BackwardAndForward build() {
            return new BackwardAndForward(this.backwardPolicy, this.forwardPolicy);
        }

        public String toString() {
            return "BackwardAndForward.BackwardAndForwardBuilder(backwardPolicy=" + this.backwardPolicy + ", forwardPolicy=" + this.forwardPolicy + ")";
        }
    }

    public static class ForwardTransitive
    implements ForwardPolicy {
        public static ForwardTransitiveBuilder builder() {
            return new ForwardTransitiveBuilder();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForwardTransitive)) {
                return false;
            }
            ForwardTransitive other = (ForwardTransitive)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForwardTransitive;
        }

        public int hashCode() {
            int result = 1;
            return result;
        }

        public static class ForwardTransitiveBuilder
        implements ObjectBuilder<ForwardTransitive> {
            ForwardTransitiveBuilder() {
            }

            @Override
            public ForwardTransitive build() {
                return new ForwardTransitive();
            }

            public String toString() {
                return "BackwardAndForward.ForwardTransitive.ForwardTransitiveBuilder()";
            }
        }
    }

    public static class ForwardTill
    implements ForwardPolicy {
        private final VersionInfo versionInfo;

        public static ForwardTillBuilder builder() {
            return new ForwardTillBuilder();
        }

        public VersionInfo getVersionInfo() {
            return this.versionInfo;
        }

        public String toString() {
            return "BackwardAndForward.ForwardTill(versionInfo=" + this.getVersionInfo() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForwardTill)) {
                return false;
            }
            ForwardTill other = (ForwardTill)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VersionInfo this$versionInfo = this.getVersionInfo();
            VersionInfo other$versionInfo = other.getVersionInfo();
            return !(this$versionInfo == null ? other$versionInfo != null : !((Object)this$versionInfo).equals(other$versionInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForwardTill;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VersionInfo $versionInfo = this.getVersionInfo();
            result = result * 59 + ($versionInfo == null ? 43 : ((Object)$versionInfo).hashCode());
            return result;
        }

        public ForwardTill(VersionInfo versionInfo) {
            this.versionInfo = versionInfo;
        }

        public static class ForwardTillBuilder
        implements ObjectBuilder<ForwardTill> {
            private VersionInfo versionInfo;

            ForwardTillBuilder() {
            }

            public ForwardTillBuilder versionInfo(VersionInfo versionInfo) {
                this.versionInfo = versionInfo;
                return this;
            }

            @Override
            public ForwardTill build() {
                return new ForwardTill(this.versionInfo);
            }

            public String toString() {
                return "BackwardAndForward.ForwardTill.ForwardTillBuilder(versionInfo=" + this.versionInfo + ")";
            }
        }
    }

    public static class Forward
    implements ForwardPolicy {
        public static ForwardBuilder builder() {
            return new ForwardBuilder();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Forward)) {
                return false;
            }
            Forward other = (Forward)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof Forward;
        }

        public int hashCode() {
            int result = 1;
            return result;
        }

        public static class ForwardBuilder
        implements ObjectBuilder<Forward> {
            ForwardBuilder() {
            }

            @Override
            public Forward build() {
                return new Forward();
            }

            public String toString() {
                return "BackwardAndForward.Forward.ForwardBuilder()";
            }
        }
    }

    public static class BackwardTransitive
    implements BackwardPolicy {
        public static BackwardTransitiveBuilder builder() {
            return new BackwardTransitiveBuilder();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BackwardTransitive)) {
                return false;
            }
            BackwardTransitive other = (BackwardTransitive)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof BackwardTransitive;
        }

        public int hashCode() {
            int result = 1;
            return result;
        }

        public static class BackwardTransitiveBuilder
        implements ObjectBuilder<BackwardTransitive> {
            BackwardTransitiveBuilder() {
            }

            @Override
            public BackwardTransitive build() {
                return new BackwardTransitive();
            }

            public String toString() {
                return "BackwardAndForward.BackwardTransitive.BackwardTransitiveBuilder()";
            }
        }
    }

    public static class BackwardTill
    implements BackwardPolicy {
        private final VersionInfo versionInfo;

        public static BackwardTillBuilder builder() {
            return new BackwardTillBuilder();
        }

        public VersionInfo getVersionInfo() {
            return this.versionInfo;
        }

        public String toString() {
            return "BackwardAndForward.BackwardTill(versionInfo=" + this.getVersionInfo() + ")";
        }

        public BackwardTill(VersionInfo versionInfo) {
            this.versionInfo = versionInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BackwardTill)) {
                return false;
            }
            BackwardTill other = (BackwardTill)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VersionInfo this$versionInfo = this.getVersionInfo();
            VersionInfo other$versionInfo = other.getVersionInfo();
            return !(this$versionInfo == null ? other$versionInfo != null : !((Object)this$versionInfo).equals(other$versionInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BackwardTill;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VersionInfo $versionInfo = this.getVersionInfo();
            result = result * 59 + ($versionInfo == null ? 43 : ((Object)$versionInfo).hashCode());
            return result;
        }

        public static class BackwardTillBuilder
        implements ObjectBuilder<BackwardTill> {
            private VersionInfo versionInfo;

            BackwardTillBuilder() {
            }

            public BackwardTillBuilder versionInfo(VersionInfo versionInfo) {
                this.versionInfo = versionInfo;
                return this;
            }

            @Override
            public BackwardTill build() {
                return new BackwardTill(this.versionInfo);
            }

            public String toString() {
                return "BackwardAndForward.BackwardTill.BackwardTillBuilder(versionInfo=" + this.versionInfo + ")";
            }
        }
    }

    public static class Backward
    implements BackwardPolicy {
        public static BackwardBuilder builder() {
            return new BackwardBuilder();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Backward)) {
                return false;
            }
            Backward other = (Backward)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof Backward;
        }

        public int hashCode() {
            int result = 1;
            return result;
        }

        public static class BackwardBuilder
        implements ObjectBuilder<Backward> {
            BackwardBuilder() {
            }

            @Override
            public Backward build() {
                return new Backward();
            }

            public String toString() {
                return "BackwardAndForward.Backward.BackwardBuilder()";
            }
        }
    }

    public static interface ForwardPolicy {
    }

    public static interface BackwardPolicy {
    }
}

