/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.pravega.common.ObjectBuilder;
import lombok.NonNull;

public class CodecType {
    public static final CodecType NONE = new CodecType("");
    private static final int MAX_PROPERTIES_SIZE = 921600;
    @NonNull
    private final String name;
    @NonNull
    private final ImmutableMap<String, String> properties;

    public CodecType(String name) {
        this(name, ImmutableMap.of());
    }

    public CodecType(@NonNull String name, @NonNull ImmutableMap<String, String> properties) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked @NonNull but is null");
        }
        Preconditions.checkArgument(properties.entrySet().stream().mapToInt(x -> ((String)x.getKey()).length() + ((String)x.getValue()).length()).reduce(0, Integer::sum) < 921600, "Invalid properties, make sure that total size of properties map is less than 900 kb.");
        this.name = name;
        this.properties = properties;
    }

    public static CodecTypeBuilder builder() {
        return new CodecTypeBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public ImmutableMap<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodecType)) {
            return false;
        }
        CodecType other = (CodecType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ImmutableMap<String, String> this$properties = this.getProperties();
        ImmutableMap<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CodecType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ImmutableMap<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "CodecType(name=" + this.getName() + ", properties=" + this.getProperties() + ")";
    }

    public static class CodecTypeBuilder
    implements ObjectBuilder<CodecType> {
        private String name;
        private ImmutableMap<String, String> properties;

        CodecTypeBuilder() {
        }

        public CodecTypeBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.name = name;
            return this;
        }

        public CodecTypeBuilder properties(@NonNull ImmutableMap<String, String> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked @NonNull but is null");
            }
            this.properties = properties;
            return this;
        }

        @Override
        public CodecType build() {
            return new CodecType(this.name, this.properties);
        }

        public String toString() {
            return "CodecType.CodecTypeBuilder(name=" + this.name + ", properties=" + this.properties + ")";
        }
    }
}

