/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import io.pravega.schemaregistry.contract.data.Compatibility;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.VersionInfo;
import lombok.NonNull;

public class GroupHistoryRecord {
    @NonNull
    private final SchemaInfo schemaInfo;
    @NonNull
    private final VersionInfo versionInfo;
    @NonNull
    private final Compatibility compatibility;
    private final long timestamp;
    private final String schemaString;

    public GroupHistoryRecord(@NonNull SchemaInfo schemaInfo, @NonNull VersionInfo versionInfo, @NonNull Compatibility compatibility, long timestamp, String schemaString) {
        if (schemaInfo == null) {
            throw new NullPointerException("schemaInfo is marked @NonNull but is null");
        }
        if (versionInfo == null) {
            throw new NullPointerException("versionInfo is marked @NonNull but is null");
        }
        if (compatibility == null) {
            throw new NullPointerException("compatibility is marked @NonNull but is null");
        }
        this.schemaInfo = schemaInfo;
        this.versionInfo = versionInfo;
        this.compatibility = compatibility;
        this.timestamp = timestamp;
        this.schemaString = schemaString;
    }

    @NonNull
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @NonNull
    public Compatibility getCompatibility() {
        return this.compatibility;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getSchemaString() {
        return this.schemaString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupHistoryRecord)) {
            return false;
        }
        GroupHistoryRecord other = (GroupHistoryRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SchemaInfo this$schemaInfo = this.getSchemaInfo();
        SchemaInfo other$schemaInfo = other.getSchemaInfo();
        if (this$schemaInfo == null ? other$schemaInfo != null : !((Object)this$schemaInfo).equals(other$schemaInfo)) {
            return false;
        }
        VersionInfo this$versionInfo = this.getVersionInfo();
        VersionInfo other$versionInfo = other.getVersionInfo();
        if (this$versionInfo == null ? other$versionInfo != null : !((Object)this$versionInfo).equals(other$versionInfo)) {
            return false;
        }
        Compatibility this$compatibility = this.getCompatibility();
        Compatibility other$compatibility = other.getCompatibility();
        if (this$compatibility == null ? other$compatibility != null : !((Object)this$compatibility).equals(other$compatibility)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$schemaString = this.getSchemaString();
        String other$schemaString = other.getSchemaString();
        return !(this$schemaString == null ? other$schemaString != null : !this$schemaString.equals(other$schemaString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupHistoryRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SchemaInfo $schemaInfo = this.getSchemaInfo();
        result = result * 59 + ($schemaInfo == null ? 43 : ((Object)$schemaInfo).hashCode());
        VersionInfo $versionInfo = this.getVersionInfo();
        result = result * 59 + ($versionInfo == null ? 43 : ((Object)$versionInfo).hashCode());
        Compatibility $compatibility = this.getCompatibility();
        result = result * 59 + ($compatibility == null ? 43 : ((Object)$compatibility).hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $schemaString = this.getSchemaString();
        result = result * 59 + ($schemaString == null ? 43 : $schemaString.hashCode());
        return result;
    }

    public String toString() {
        return "GroupHistoryRecord(schemaInfo=" + this.getSchemaInfo() + ", versionInfo=" + this.getVersionInfo() + ", compatibility=" + this.getCompatibility() + ", timestamp=" + this.getTimestamp() + ", schemaString=" + this.getSchemaString() + ")";
    }
}

